-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
package body El.Classe.Cars_class is
   
   function Car_immat_Value(Line : in Wide_String) return Name_type is
      Immat : Name_type := (others => Wide_Character'Val(32));
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last), " ", backward); 
      
   begin
      if Last_2 /= 0 then
	 Wide_Fixed.Move(Line(Last_2+1 .. Line'last), immat);
      end if;      
      return immat;
   exception
      when others =>
	 return immat;
   end Car_immat_Value;
   
   
   function Car_genre_Value(Line : in Wide_String) return Name_type is
      genre : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
      
      Next_2 :  Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), " ");
      
   begin
      if Next /= 0 then
	 Wide_Fixed.Move(Line(Last_2+1..Next_2-1), genre);
      end if;      
      return genre;
   exception
      when others =>
	 return genre;
   end Car_genre_Value;
   
   function Mark_Value(Line : in Wide_String) return Name_type is
      Mark : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
   begin
      if Next /= 0 then
	 Wide_Fixed.Move(Line(Last+1..Last_2-1), Mark);
      end if;      
      return Mark;
   exception
      when others =>
	 return Mark;
   end Mark_Value;
   
   -----------------------------------------------------------------------------
   --                  Car                                                 --
   
   procedure Help(Car    : in out Car_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create car : help");
      Draw(Win, Win_Index+2, 3, Cyan,
	   "Name is string.");
      Draw(Win, Win_Index+3, 3, Cyan,
	   "Mark is string.");
      Draw(Win, Win_Index+4, 3, Cyan,
	   "Gente is string.");
      Draw(Win, Win_Index+5, 3, Cyan,
	   "Immat is string.");      
      Draw(Win, Win_Index+6, 3, Cyan,
	   "create CAR Name Mark Genre Immat");
      Win_Index := Win_Index + 7;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');
   end Help;
   
   
   procedure Print (Object : Car_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Cyan, "Index   : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      
      Draw(Win, Win_Index+2, 3, Cyan, "Name    : " & Object.Name);
      Draw(Win, Win_Index+3, 3, Cyan, "Created : "
	     & To_Wide_String(Image(Object.Create_Date)));      
      
      Draw(Win, Win_Index+4, 3, Cyan, "Mark   : "
	     & Object.mark);
      
      Draw(Win, Win_Index+5, 3, Cyan, "Genre   : "
	     & Object.Genre);
      
      Draw(Win, Win_Index+6, 3, Cyan, "Immat   : "
	     & Object.Immat);
      
      
      Win_Index := Win_Index + 7;
      
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
      
      Name := Object.Name;
   end Print;
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Name      : in Name_Type;
		   Mark      : in Name_Type;
		   genre     : in Name_Type;
		   Immat     : in Name_Type) return Abstracted_Access is

      O : Abstracted_Access := new Car_Class;
      Label : Name_Type;
   begin
      if O /= null then
	 Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	 Car_Class(O.all).mark := mark;
	 Car_Class(O.all).Genre := Genre;
	 Car_Class(O.all).Immat := immat;	 
	 Car_Class(O.all).Print(Win, Win_Index, Label);
	 return O;
      else
	 return null;
      end if;
   end Create;
   procedure Write (O : in Car_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, O.Mark);
      W_Io.Put_Line(File, O.genre);
      W_Io.Put_Line(File, O.immat);
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
   procedure Read (O : in out Car_Class;File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      Empty : Wide_String (1..80);
      Empty_Last : natural := 0;
      Genre : Name_Type := (others => ' ');
      Genre_Last : Natural := 0;      
      
      Att_Index : Natural := 0;
   begin
      
      O.Index := Integer'Value(To_String(W_Io.Get_Line(File)));
      
      O.Create_Date := Value(To_String(W_Io.Get_Line(File)));
      
      W_Io.Get_Line(File, O.Name, Name_last);            
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      
      
      -- obscure blank line      

      
      W_Io.Get_Line(File, O.Mark, Genre_Last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      
      
      -- obscure blank line      

      
      W_Io.Get_Line(File, O.Genre, Genre_Last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      

      -- obscure blank line      

      W_Io.Get_Line(File, O.immat, Genre_Last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;


   end Read;
   
   procedure Random (O : in out Car_Class) is
   begin
      null;
   end Random;
   --
   -----------------------------------------------------------------------------

end El.Classe.Cars_class ; 
