-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package El.Axiome is
   type Ternary_enum is (Nice, Bad, Uncknow);
   
   package Main_Work is
      
      type Binaire is (Vrai, Faux);
      
      function "not" (Veracite : Binaire) return Binaire;
      function "and" (Left, Right : Binaire) return Binaire;
      function "or" (Left, Right : Binaire) return Binaire;
      
      function To_Boolean (Verite : in Binaire) return Boolean;
      
      function To_Binaire(Veracity : in Boolean) return Binaire;
            
      type Result_Record is tagged
	 record     
	    Know    : Boolean := True;
	    Have    : Boolean := True;
	    Peace   : Ternary_Enum := Uncknow;
	    Love    : Ternary_Enum := Uncknow;
	    War     : Ternary_Enum := Uncknow;
	    Reason  : Boolean := False;
	    Freedom : Boolean := False;
	    Power   : Ternary_Enum := Uncknow;
	    Will    : Ternary_Enum := Uncknow;
	    Loose   : Ternary_Enum := uncknow;       
	 end record;      
      
      function  From_line (Line : in String) return Result_Record;
      function To_String (Result : in Result_Record) return String;
	 
      
      
      type Preuve_Record is new Result_Record with
	 record
	    Veritable : Boolean := false;
	    Veracity  : Boolean := False;
	    Verified  : Boolean := False;
	 end record;
      
      procedure Verifiing (Preuve : in out Preuve_Record);
      
      function To_String (Preuve : in Preuve_Record) return String;
      function  From_line (Line : in String) return Preuve_Record;   
      function To_State (Preuve : in Preuve_Record) return Boolean;
      
      
   end Main_Work;
   
   use Main_Work;
   function Veritable(Line : in String) return Boolean;
      
   function Veracity (Line : in String) return Boolean;
   

end El.Axiome ; 
