-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   <one line to give the program's name and a brief idea of what it does.>
--   Copyright (C) 19yy  <name of author>
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package El.Aiinfo is
   type Nn_Info_Record is tagged
      record
	 RMS_Error     : Float := 0.0;	 
	 Current_Epoch : Natural := 0;
	 Converged     : Boolean := False;
      end record;
   
   type Class_Info_Record is tagged
     record
	Current_Tag   : Tag_Name := Null_Tag;
	Hcost         : Float := 0.0;
	Ucos          : Float := 0.0;	
     end record;
   
   Null_Tag_Info : constant Class_Info_Record := (Null_Tag, 0.0, 0.0);
   
   type Class_Rank is array (Positive range 1..Tag_Name'Pos(Tag_Name'Last)) of Class_Info_Record;
   
   type Path_Info is tagged
      record
	 Rankning     : Class_Rank := (others => Null_Tag_Info);
	 Close_Size   : Natural := 0;
	 Open_Size    : Natural := 0;
      end record;
   
   type Aiinfo_Record is new Path_Info with     
      record
	 Layer_0       : Nn_Info_Record;
	 Layer_2       : Nn_Info_Record;	 	 
	 State         : Boolean := False;
      end record;

end El.Aiinfo ; 
