-- Main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-28 00:37:01 ; 
-- Version := 0.17.0a ; 
with M ; 
with M.Errors ; 
with M.Parameters ; 
with M.Options ; 
with M.Enums ; 
with M.Types ; 
with M.Interfaces ; 
with M.Logs;
use M.Logs;
with M.Account;
with M.Accounts_Manager;
use M.Account;
use M.Accounts_Manager;

with M.Projects_Manager;
use M.Projects_Manager;
with M.Project;
use M.Project;
with M.Classes;

with M.Ansi.Console ;
with M.Ansi.Windows ;
with M.Windows ;
with M.Strings ;
with M.Main_Game;
use M.Main_Game;

with Gnat.Os_Lib;
use Gnat.Os_Lib;

with El.Lexics;
with El.Hander;
with El.Frames;
with El.Classe;

use El;
with M.Engineering;
with M.Engine;
with M.Servers ;
generic
   with package Ansi_Windows is new M.Ansi.Windows (<>);
   with package Windows is new M.Windows (<>) ;
   with package Hander is new El.Hander (<>) ;
   with package Words_Glossary is new El.Lexics.Glossary (<>);
   
package M.Agence is
   use Hander;
   use Words_Glossary;
   --use Hander.Words_Glossary;
   package Frames is new El.Frames (Windows);
   use Frames ;
   
   use M.Strings;
   package Classes is new M.Classes (Windows.Ansi_Windows);
   use Classes;
   package Engine is new M.Engine(Windows.Ansi_Windows);
   use Engine;
   package Engineering is new M.Engineering (Windows, Classes, Engine);
   use Engineering;
   --   use Engineer.Classes;
   
   procedure Save (Object : in Abstract_Access;
   		   Filename : in String);
   type Agence_Record;
   
   type Abstract_Mode is abstract tagged limited null record;
   
   type All_Mode(Name : Mode_Enum) is new Abstract_Mode with null record;
   
   type All_Access is access All_Mode'class;
   
   type Mode_Array is array (Natural range <>) of All_Access;
   
   type App_Access is access all Agence_Record;
   
   task type Console_Process(Agence : access Agence_Record) is
      entry Initialize;
      entry Receive(Wchar : in Wide_Character);
      entry Halt;
      entry Mode(Mode : out Mode_Enum);
      entry Reset;
      entry Switch (Mode : in Mode_Enum);
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
   end Console_Process;

   
   type Logs_Record(App : App_Access);
   task type Logs_Process (Mode : access Logs_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Logs_Process;
   type Logs_Record(App : App_Access) is new All_Mode(Log) with
      record
	 Proc : Logs_Process(Logs_Record'Access, App);
      end record;
   
   
   type None_Record(App : App_Access);
   task type None_Process (Mode : access None_Record; App : App_Access) is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Halt;
      entry Suspend;
      entry Wake_Up(Top : in Natural);
      entry Refresh;
      entry Page_Up;
      entry Page_Down;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;

      entry Del;

      entry Begin_Of;

      entry End_Of;
      
      entry Overwrite;

      entry Screen_Print;
      
   end None_Process;
   type None_Record(App : App_Access) is new All_Mode(None) with
      record
	 Proc : None_Process(None_Record'Access, App);	    
      end record;
   
   
   subtype Cpu_String is String (1..6);
   
   Home_Dir : String := Getenv("HOME").all;
   
   task CPU_Process is
      entry Initialize;
      entry Cpu_Get(CPU_Usage : out CPU_String);
      
      entry Halt;
   end CPU_Process;
   
   
   
   -------------------------------------------------------------
   --                         Organizer                       --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Organizer_Record(App : App_Access);
   task type Organizer_Process (Mode : access Organizer_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Organizer_Process;
   type Organizer_Record(App : App_Access) is new All_Mode(Organizer) with
      record
	 Proc : Organizer_Process(Organizer_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                      Virtual_Brain                      --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Vbrain_Record(App : App_Access);
   task type Vbrain_Process (Mode : access Vbrain_Record; App : App_Access)  is
      pragma Storage_Size (268435456);
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
      entry Dialog;
      entry Refresh;
      entry Screen_Print;
   end Vbrain_Process;
   type Vbrain_Record(App : App_Access) is new All_Mode(Dialog) with
      record
	 Proc : Vbrain_Process(Vbrain_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                      Workstation                        --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Workstation_Record(App : App_Access);
   task type Workstation_Process (Mode : access Workstation_Record; App : App_Access)  is
      pragma Storage_Size (268435456);
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
      entry Dialog;
      entry Refresh;
      entry Screen_Print;
   end Workstation_Process;
   type Workstation_Record(App : App_Access) is new All_Mode(Terminator) with
      record
	 Proc : Workstation_Process(Workstation_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                       Space Fighter                     --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Space_Fighter_Record(App : App_Access);
   task type Space_Fighter_Process (Mode : access Space_Fighter_Record; App : App_Access)  is
      pragma Storage_Size (268435456);
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
      entry Dialog;
      entry Refresh;
      entry Screen_Print;
   end Space_Fighter_Process;
   type Space_Fighter_Record(App : App_Access) is new All_Mode(Joshua) with
      record
	 Proc : Space_Fighter_Process(Space_Fighter_Record'Access, App);
      end record;
   

   
   
   -------------------------------------------------------------
   --                        Planning                         --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Planning_Record;
   task type Planning_Process (Mode : access Planning_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Planning_Process;
   type Planning_Record(App : App_Access) is new All_Mode(Planning) with
      record
	 Proc : Planning_Process(Planning_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                         Manager                         --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   type Manager_Record(App : App_Access);
   task type Manager_Process (Mode : access Manager_Record; App : App_Access) is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      
      entry Halt;
   end Manager_Process;
   type Manager_Record(App : App_Access) is new All_Mode(Manager) with
      record
	 Proc : Manager_Process(Manager_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                       MoneyBox                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Moneybox_Record(App : App_Access);
   task type MoneyBox_Process (Mode : access MoneyBox_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Full_Screen;
      entry Screen_Print;
      entry Halt;
   end MoneyBox_Process;
   type MoneyBox_Record(App : App_Access) is new All_Mode(Moneybox) with
      record
	 Proc : MoneyBox_Process(MoneyBox_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                          Activity                       --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Activity_Record(App : App_Access);
   task type Activity_Process (Mode : access Activity_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Activity_Process;
   type Activity_Record(App : App_Access) is new All_Mode(Activity) with
      record
	 Proc : Activity_Process(Activity_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                          Stocks                         --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Stocks_Record(App : App_Access);
   task type Stocks_Process (Mode : access Stocks_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Full_Screen;
      entry Screen_Print;
      entry Halt;
   end Stocks_Process;
   type Stocks_Record(App : App_Access) is new All_Mode(Stocks) with
      record
	 Proc : Stocks_Process(Stocks_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                           Bank                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Bank_Record(App : App_Access);
   task type Bank_Process (Mode : access Bank_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Bank_Process;
   type Bank_Record(App : App_Access) is new All_Mode(bank) with
      record
	 Proc : Bank_Process(Bank_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                          Menu                           --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Menu_Record(App : App_Access);
   task type Menu_Process (Mode : access Menu_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Menu_Process;
   type Menu_Record(App : App_Access) is new All_Mode(Menu) with
      record
	 Proc : Menu_Process(Menu_Record'Access, App);
      end record;

   
   
   -------------------------------------------------------------
   --                         Contact                         --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Contacts_Record(App : App_Access);
   task type Contacts_Process (Mode : access Contacts_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Contacts_Process;
   type Contacts_Record(App : App_Access) is new All_Mode(Contacts) with
      record
	 Proc : Contacts_Process(Contacts_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                          Library                        --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Library_Record(App : App_Access);
   task type Library_Process (Mode : access Library_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Library_Process;
   
   type Library_Record(App : App_Access) is new All_Mode(Library) with
      record
	 Proc : Library_Process(Library_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                      Master/Navigation                  --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   
   type Master_Record(App : App_Access);
   task type Master_Process (Mode : access Master_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Master_Process;
   type Master_Record(App : App_Access) is new All_Mode(Navigation) with
      record
	 Proc : Master_Process(Master_Record'Access, App);
      end record; 
  
   
   -------------------------------------------------------------
   --                          Engine/Engineer                 --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Engine_Record(App : App_Access);
   task type Engine_Process (Mode : access Engine_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Engine_Process;
   type Engine_Record(App : App_Access) is new All_Mode(Engineer) with
      record
	 Proc : Engine_Process(Engine_Record'Access, App);
      end record; 
  
   -------------------------------------------------------------
   --                          Computer                        --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Computer_Record(App : App_Access);
   task type Computer_Process (Mode : access Computer_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Computer_Process;
   type Computer_Record(App : App_Access) is new All_Mode(Agent) with
      record
	 Proc : Computer_Process(Computer_Record'Access, App);
      end record;
   
   -------------------------------------------------------------
   --                          WOPR                        --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type WOPR_Record(App : App_Access);
   task type WOPR_Process (Mode : access WOPR_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end WOPR_Process;
   
   type WOPR_Record(App : App_Access) is new All_Mode(Admin) with
      record
	 Proc : WOPR_Process(WOPR_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                          Entreprise                        --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Person_Record(App : App_Access);
   task type Person_Process (Mode : access Person_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Person_Process;
   
   type Person_Record(App : App_Access) is new All_Mode(Entreprise) with
      record
	 Proc : Person_Process(Person_Record'Access, App);
      end record;
   
   
   
   
   
   
   
   type World_Record(App : App_Access);
   
   task type Conductor_Process (Mode : access World_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Conductor_Process;
   
   type World_Record(App : App_Access) is new All_Mode(Process) with
      record
	 Proc : Conductor_Process(World_Record'Access, App);
      end record;
   
   
   
   
   
   
   
   use Windows ;

   type Accounting_Windows_Type is
      record
	 Voice_Num_Win     : Window_Record;
	 Acc_Num_Win       : Window_Record;
	 Total_Ht_Win      : Window_Record;
	 Total_TVA_Win     : Window_Record;
	 Total_TTC_Win     : Window_Record;
	 Date_Win          : Window_Record;
	 Peer_Win          : Window_Record;	 
      end record;   
   
   type Ticket_Windows_Type is
      record
	 Line_Num_Win      : Window_Record;
	 Description_Win   : Window_Record;
	 Unit_Ht_Win       : Window_Record;
	 Quantity_Win      : Window_Record;
	 Total_Ht_Win      : Window_Record;
	 TVA_Win           : Window_Record;
	 Total_TVA_Win     : Window_Record;
	 Total_TTC_Win     : Window_Record;
      end record;   
   
   type stock_Windows_Type is
      record
	 stock_Num_Win     : Window_Record;
	 Name_Win          : Window_Record;
	 Quantity_Win      : Window_Record;
	 Unit_Ht_Win       : Window_Record;
	 TVA_Win           : Window_Record;

      end record;   
   
   
   
   
   
   type Agence_Record is new Engineering_Record with 
      record
	 Lines         : Line_Range := 67;
	 Columns       : Column_Range := 240;
	 Term    : Term_Enum := Linux;
	 Mode    : Mode_Enum := Auth;
	 Desktop : Mode_Array(1..2);
	 Console : Console_Process (Agence_Record ' access);
	 
	 On_Esc : Boolean := False;
	 
	 ------------------------------------------------------------
	 --               Neural network
	 Wline            : Wide_String_Access := new Wide_String ' ("");
	 Wbuffer          : Wide_String_Access;
	 Current_Pos      : Natural := 1;      
	 Wline_Length     : Natural := 0;
	 Word_Number      : El.Word_Range := 0;
	 Dialog_Response  : Wide_String_Access := new Wide_String ' ("");
	 Response_Buffer  : Wide_String_Set(1); 
	 Internal         : Wide_String_Access := new Wide_String ' ("");
	 internal_Buffer  : Wide_String_Set(1); 
	 
	 Set_Filename : access String := new String ' ("samples_set.txt");
	 
	 Input            : Neural_Retrain.Input_Type;
	 Output           : Neural_Retrain.Output_Type;
	 Feedback         : Neural_Retrain.Output_Type;-- := String2input(To_String(Preuve));
	 Samples_Set      : aliased Neural_Train.Sample_Set_Type;
	 Samples          : aliased Neural_Retrain.Sample_Set_Type;
	 Words            : Glossary.Glossary_Type;
	 Frames           : Frame_Set;
	 
	 ------------------------------------------------------------
	 --                 Money Box
	 
	 Ticket_Wins       : Ticket_Windows_Type;
	 
	 ------------------------------------------------------------
	 --                 Stocks
	 
	 Stocks_Wins       : Stock_Windows_Type;
	 
	 ------------------------------------------------------------
	 --                Activity
	 
	 Activity_Wins     : Accounting_Windows_Type;
	 
	 
	 
	 Initialized       : Boolean := False;
	 
	 
	 
	 ------------------------------------------------------------
	 --                     Entreprise
	 Self : Terminal_Type;
	 View_Wins         : Accounting_Windows_Type;
	 Created           : Boolean := False;
	 
	 ------------------------------------------------------------
	 --                Library
	 Rented, Backed, Owner : Classes.Abstract_Access;
	 List                  : Classes.Abstract_Vectors.vector;
	 
	 ------------------------------------------------------------
	 --                  Bank
	 Bank : Account_Manager;
	 
	 ------------------------------------------------------------
	 --                   Server
	 Started  : Boolean := False;
	 
	 
	 
      end record;
   
   
   procedure Restore(T : in out Terminal_Type;
   		     Filename : in String);
   
   
   
   
   App    : aliased Agence_Record;
   
   
   package Servers is new M.Servers (Engineering, Engineering_Record(App)'Access);
   use Servers;
   
   
   Functions : Mode_Array(0..20);
end M.Agence ; 
