-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-06-07 03:11:02 ; 
-- Version := 0.30.0a ; 
package Sky is
   pragma Pure (Sky);
   type Int_Cmd_Enum is (None, Alias, Unalias, Cd, Set, Unset, Put, Put_Line);
   subtype Wstring_16 is Wide_String(1..16); 
   
   
   subtype Wstring_42 is
     Wide_String(1..42); 
   
   subtype Wstring_45 is
     Wide_String(1..45); 
   
   subtype Wstring_32 is
     Wide_String(1..32); 
   
   
   subtype Designation_Line is Wide_String(1..24);
   
   
     
   type Fixed_Sum is delta 0.01 digits 12 range
   -9_9999_999.00..9_999_999.00;
   
   subtype Days_Delay is Integer range -150 .. 150;
   
   
   type Fixed_Out is delta 0.01 digits 13 ; 
   type Fixed_In is delta 0.01 digits 13 ; 
   type Fixed_Account is delta 0.01 digits 13 ; 
   type Fixed_Factor is delta 0.01 digits 6 range 0.0 .. 1000.0;
   
   
   subtype Account_Num_Range is Positive range 10..899_999; type
   Fixed_Unit_Ht is delta 0.01 digits 8 range -99_999.99 .. 99_999.99;
   type Fixed_Unit_TTC is delta 0.01 digits 16 range -999_999_999.99 .. 999_999_999.99; 
   subtype Quantity_Range is float range -100_000.0..100_000.0; 
   type Fixed_Total is delta 0.01 digits 14 range -9_999_999_999.99 .. 9_999_999_999.99;
   
   subtype Payment_Delay is Integer range -120..120;
   
   
   
   
  
   type Deal_Enum is (Deal_In, Deal_Out);
   
   
   subtype Voice_Num_Range is Natural range Natural'First..Natural'Last;
   
   
   subtype Product_Name is WString_32;
end Sky ; 
