--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-12-04 15:05:40 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.34.3a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------

with Gnat.Os_Lib;
with Ada.Directories;
use Ada.Directories;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Gnos.Versions;
with Ada.Text_Io;
with Ada.Directories;
with ada.strings.fixed;
use ada.strings.fixed;
use ada.strings;
use Ada.TEXT_IO;
with Ada.Calendar.Formatting;
use Ada.Calendar;
with Gnat.Directory_Operations;
use Gnat.Directory_Operations;
package body Gnos.Versions.Environment is
   
   procedure Set_Date(Date : out Date_Type; To : in Calendar.Time) is
      
   begin
      Calendar.Split(To, Date.Year, Date.Month, Date.Day, Date.Hours);
   end Set_date;
   
   function Version_Reset return Integer is
   begin
      Versions.Version.Major_Version := Versions.Major_Version_Type'First;
      Versions.Version.Minor_Version := Versions.Minor_Version_Type'First;
      Versions.Version.Revision_Version := Versions.Revision_Version_Type'First;
      Versions.Version.Release_Version := 'a';
      return 0;
   end Version_Reset;
   
   function Version_Update return Integer is
   begin
      --Set_date(Shared_Date, Calendar.Clock);
      if not New_Version then
	 return 0;      
      end if;
      -- Change major if is the current year > Major_Version.
      if Versions.Version.Major_Version < Calendar.Year(Calendar.Clock) then 
	 if Versions.Version.Major_Version + 1 < Major_Version_Type'Last then
	    Versions.Version.Major_Version := Versions.Version.Major_Version + 1;
	    Versions.Version.Minor_Version := 0;
	    Versions.Version.Revision_Version := 0;
	 else
	    return -1;
	 end if;
      end if;
      if New_Description or New_Action then
	 Versions.Version.Release_Version := 'a';
      elsif Versions.Version.Release_Version = 'a' then
	 Versions.Version.Release_Version := 'b';
      else
	 return 0;
      end if;      
            
      -- Change minor if some data description is modified or added.
      if New_Description then	    
	 if Versions.Version.Minor_Version + 1 < Minor_Version_Type'Last then
	    Versions.Version.Minor_Version := Versions.Version.Minor_Version + 1;	      
	    Versions.Version.Revision_Version := 0;		  	    
	 else
	    return -1;
	 end if;
      end if;
      
      -- Change minor if some function is modified or added.
      if New_Action then	       
	 if Versions.Version.Revision_Version + 1 < Revision_Version_Type'Last then
	    Versions.Version.Revision_Version := Versions.Version.Revision_Version + 1;
	 else
	    return -1;
	 end if;
      end if;
      
      return 0;

   end Version_Update;
   
   
      
   procedure Set_Start_Time(Date : in Calendar.Time := Calendar.Clock) is
   begin
      Set_Date(Start_Date, Date);
   end Set_Start_Time;
   
   function Check_Modification_To_New_Description(Project_Context : in Projects_Context_Record) return Boolean is
      
      To_Be_Updated : Boolean := False;
      Buffer : Variadic_Access;
      Initialized : Boolean := False;
   begin

      for File_Id in 1..Project_Context.Project.Proj_Library.Unit_Index loop

	 declare
	    file_name : string := Project_Context.Project.Proj_Library.Library_Unit(File_Id).File_Name
	      (1..index_non_blank(Project_Context.Project.Proj_Library.Library_Unit(File_Id).File_Name, backward));
	    
	 begin
	    
	    if Extension(file_name) = "ads" then

	       begin
		  null;
		  
	       exception
		  when Directories.USE_Error =>
		     Put_Line("Use error");
		  when Directories.Name_Error =>
		     Put_Line("name error");
	       end;
	       
	       
	       if Calendar.">"(Directories.Modification_Time(File_Name),
			       Calendar.Time_Of(Start_Date.Year, Start_Date.Month, Start_Date.Day, Start_Date.Hours)) then
		  
		  
		  To_Be_Updated := True;


		     
		  
		  if Initialized then

		     Buffer := new Variadic_Array(1..(Specifications_Filenames_Search.File_Content'Length)+1);
		     Buffer(Buffer'First..Buffer'Last-1) := Specifications_Filenames_Search.File_Content.all;
		     Buffer(Buffer'Last) := (+(To_Wide_String(File_Name)));
		  else

		     Buffer := new Variadic_Array(1..1);
		     Buffer(Buffer'Last) := (+(To_Wide_String(File_Name)));
		     Initialized := True;
		  end if;
		  
		  

	       
		  Free(Specifications_Filenames_Search.File_Content);
		  Specifications_Filenames_Search.File_Content := new Variadic_Array ' (Buffer.all);

		  Free(Buffer);
                     	                         			   
		  
	       end if;
	    end if;

	end;
      end Loop;

      return To_Be_Updated;
   end;
   
   function Check_Modification_To_New_Action(Project_Context : in Projects_Context_Record)  return Boolean is
   
      To_Be_Updated : Boolean := False;
      Buffer : Variadic_Access;
      Initialized : Boolean := False;
   begin
      for File_Id in 1..Project_Context.Project.Proj_Library.Unit_Index loop
	declare
		file_name : string := Project_Context.Project.Proj_Library.Library_Unit(File_Id).File_Name
		  (1..index_non_blank(Project_Context.Project.Proj_Library.Library_Unit(File_Id).File_Name, backward));
	begin
	   
	   if Extension(File_Name) = "adb" then
	      
	      if Calendar.">"(Directories.Modification_Time(File_Name),
			      Calendar.Time_Of(Start_Date.Year, Start_Date.Month, Start_Date.Day, Start_Date.Hours)) then
		 
		 Text_Io.Put_Line("Modified filename : " & File_Name);
		 To_Be_Updated := True;
		 
		 
		 if Initialized then
		    Buffer := new Variadic_Array(1..(Implementations_Filenames_Search.File_Content'Length)+1);
		    Buffer(Buffer'First..Buffer'Last-1) := Implementations_Filenames_Search.File_Content.all;
		    Buffer(Buffer'Last) := (+(To_Wide_String(File_Name)));
		 else
		    Buffer := new Variadic_Array(1..1);
		    Buffer(Buffer'Last) := (+(To_Wide_String(File_Name)));
		    Initialized := True;
		 end if;
		 
		 
		 
		 
		 Free(Implementations_Filenames_Search.File_Content);
		 Implementations_Filenames_Search.File_Content := new Variadic_Array ' (Buffer.all);
		 Free(Buffer);

		 
	      end if;
	   end if;
	end;
      end Loop;
      
      return To_Be_Updated;
   end;   
   
   
end Gnos.versions.Environment;
