-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-23 21:09:01"
-- Version := "1.0.0a"
with El.Outils;
package body El.Version_Io is
   function To_String (Version : in     Version_Record; Separator : in Character := '.') return String is
   begin
      
      return 	
	Outils.Integer_Image(Version.Major_Version) & Separator &
	Outils.Integer_Image(Version.Minor_Version) & Separator &
	Outils.Integer_Image(Version.Revision_Version) &
        Version.release_Version;

end To_String;
end El.Version_Io;
