-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package El.Option is
         type Optionals_Flags_Enum_Type is
     -- Options flags enumeration ;
     (
      Null_Option,
      Config_Filename,
      Help,      
      Quiet,
      Version,
      Geometry,
      Username,
      Address,                  
      Input_Text,
      Term_name,
      Samples_Filename,
      Max_Epochs,
      Converged,
      Reuse,
      Train,
      Num_Samples,      
      Line_Width,
      Words_Max,
      Num_Hidden,
      Update,
      As_Server,
      style
	
     );
   
   type Option_Tagged_Type (Requiered_Parameter : Boolean) is tagged
     -- Option type is tagged ; with Requiered_Parameters is Boolean ;
      record
	 
	 Is_Setted    : Boolean            := False;
	 -- True if occure on Command line ; Default False ;
	 
	 Optionals_Flags : Optionals_Flags_Enum_Type := Null_Option;
	 -- Flag of Option occurence ; Default Null_Option ;
	 
	 case Requiered_Parameter is
	    -- case Requiered_Parameter is
	    when False =>	       
	    -- when False =>
	       
	       null;
	       
	       --null ;
	       
	    when True =>
	       -- when True =>
	       Value : access Wide_String;
	      
	      -- Value is image of parameter.
	      
	 end case;
	 
      end record;
   
   type Options_Kit_Array_Type is 
     -- Option_Kit is array ;
     array (Optionals_Flags_Enum_Type'range) 
     -- range Options_Flags_Enum_Type enumeration
     of access Option_Tagged_Type;
   -- of access to Option_Type ;
   
   
   Full_Line_Options_Kit : constant Options_Kit_Array_Type :=
     -- Full_Options_Kit is constant Options_Kit_Array_Type     
     (
            -- where
      Null_Option => 
     	-- Null_Option is
     	new Option_Tagged_Type (False),
      -- Default_Null_Option ; defined line "37" ;
      
      Config_Filename => new Option_Tagged_Type (True),
      Help => new Option_Tagged_Type (False),
      Quiet => new Option_Tagged_Type (False),
      Version => new Option_Tagged_Type (False),
      Geometry => new Option_Tagged_Type (True),
      Username => new Option_Tagged_Type (True),
      Address => new Option_Tagged_Type (True),      
      Input_Text  => new Option_Tagged_Type (True),
      Term_name  => new Option_Tagged_Type (True),
      Samples_Filename => new Option_Tagged_Type (True),
      Max_Epochs => new Option_Tagged_Type (True),
      Converged=> new Option_Tagged_Type (True),      
      Reuse  => new Option_Tagged_Type (False),
      Train  => new Option_Tagged_Type (False),
      Num_Samples  => new Option_Tagged_Type (True),      
      Line_width => new Option_Tagged_Type (True),
      Words_max => new Option_Tagged_Type (True),
      Num_hidden => new Option_Tagged_Type (True),
      Update => new Option_Tagged_Type (True),
      As_server => new Option_Tagged_Type (False),
      Style => new Option_Tagged_Type (True)
	
     );     
   
   Full_File_Options_Kit : constant Options_Kit_Array_Type :=
     -- Full_Options_Kit is constant Options_Kit_Array_Type     
     (
      -- where
      Null_Option => 
     	-- Null_Option is
     	new Option_Tagged_Type (False),
      -- Default_Null_Option ; defined line "37" ;
      
      Config_Filename => new Option_Tagged_Type (True),
      Help => new Option_Tagged_Type (False),
      Quiet => new Option_Tagged_Type (False),
      Version => new Option_Tagged_Type (False),
      Geometry => new Option_Tagged_Type (True),
      Username => new Option_Tagged_Type (True),
      Address => new Option_Tagged_Type (True),      
      Input_Text  => new Option_Tagged_Type (True),
      Term_name  => new Option_Tagged_Type (True),
      Samples_Filename => new Option_Tagged_Type (True),
      Max_Epochs => new Option_Tagged_Type (True),
      Converged=> new Option_Tagged_Type (True),      
      Reuse  => new Option_Tagged_Type (False),
      Train  => new Option_Tagged_Type (False),
      Num_Samples  => new Option_Tagged_Type (True),      
      Line_width => new Option_Tagged_Type (True),
      Words_max => new Option_Tagged_Type (True),
      Num_hidden => new Option_Tagged_Type (True),
      Update => new Option_Tagged_Type (True),
      As_server => new Option_Tagged_Type (False),
      Style => new Option_Tagged_Type (True)
     );     
   
   Default_Null_Option : constant access Option_Tagged_Type :=
       -- Default_Null_Option is constant access to
     new Option_Tagged_Type (False);     
   -- new Option_Tagged_Type(False);   
   
   function Get_Options_From_Command_Line
     -- To get Options_Kit_array_Type from argument in command_line ;
     
     return Options_Kit_Array_Type;
   -- return Options_Kit_Array_Type;  
   
   
   function Get_Options_From_File
     (Filename : in Wide_String)
     -- To get Options_Kit_array_Type from argument in file ;
     
     return Options_Kit_Array_Type;
   -- return Options_Kit_Array_Type;  


end El.Option ; 
