-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Strings;
generic
   Term_Columns_Max : Positive := 240;

package El.Classe.Contents_class is
   use Strings;
   --------------------------------------------------------------------------
   --                        CONTENT
   
   subtype description_type is Wide_String(1..(Term_Columns_Max-6)/4-8);
   
   function description_Value(Line : in Wide_String) return Description_Type;
   
   subtype Price_Type is Float range 0.0..99_999.99;
   
   
   function Price_Value(Line : in Wide_String) return Price_Type;
   
   type Content_Class is new Abstracted_Class(Content) with
      record	 
	 Price       : Price_Type := 0.0;
	 description : description_type := (others => Wide_Character'Val(32));
      end record;
   
   procedure Print (Object    : in Content_Class'class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Help(Content   : in out Content_Class'class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;		   
		   Name      : in Name_Type;
		   Price     : in Price_Type;
		   Description : in Description_type) return Abstracted_Access;
   
   procedure Write (O : in Content_Class; File : in W_Io.File_Type);
   procedure Read (O : in out Content_Class; File : in W_Io.File_Type);
   procedure Random (O : in out Content_Class);
   --                  End CONTENT   
   --------------------------------------------------------------------------

end El.Classe.Contents_class ; 
