-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Elhoim ;
with El.Config ;
with El.Shells ;
with El.Docume ;
with El.Player ;
with El.Aiinfo ;
with El.Axiome ;
with El.Frames ;
with El.Result ;
with El.Classe ;
with El.Window ;
with El.Applic ;
with El.Styles ;
with El.Enumes ;
with El.Search ;
with El.Strings;

with Gnat.Sha1; use Gnat;
with Gnat.Os_Lib;
with Gnat.Semaphores;
use Gnat.Semaphores;
use Gnat;
generic
   Ptr_Max : Positive;
   This_Center : Applic.Applic_Record;
   with package Window is new El.Window (<>);
   Glossary_Filename : String;
   Width_Line :Word_Range;
   Max_Words : Lexical_Range;
   Samples_Max : Positive;
   Network_Filename : String;
   with package Classes is new El.Classe (<>);
   
   Lines : Line_Range := 67;
   Cols : Column_Range := 240;

package El.Center is
   
   use Strings ;
   use Enumes ;
   use Result ;
   use Window ;
   use Styles ;
   use Shells ;
   use Docume ;
   use Player ;
   use Aiinfo ;
   use Axiome ;
   use Axiome.Main_Work ;
   
   package Frames is new El.Frames (Window);
   use Frames ;
   
   type Center_Record;
   
   task type Console_Process (Center : access Center_Record) is
      entry Halt (End_Of_Program : out Boolean);
      entry Initialize (Mode : Mode_Enum; User_Text : in Wide_String);
      entry Receive (Wchar : in Wide_Character);
      entry Mode(Mode : out Mode_Enum);
      entry Reset;
      entry Switch (Mode : in Mode_Enum);
      entry Multi_Switch (Mode : in Mode_Enum);
      entry Lock;
      entry Wake_Up(Mode : in Mode_Enum);
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      
      entry F9;   -- Organizer : New_Goal
      entry F10;  -- Organizer : Goal_Path_Tree_View
      entry F11; -- Organizer : Add_Goal_Path;
      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Shutdown;
   end Console_Process;

   
   task type Center_Process (Center : access Center_Record) is
      entry Initialize (Mode : Mode_Enum; User_Text : in Wide_String);
      entry Restart;
      entry Halt;      
   end Center_Process;
   
   task type Work_Process (Center : access Center_Record) is
      entry Initialize;
      entry wait;
      entry Halt;
   end Work_Process;
   
   
   
   package Config is new El.config (Glossary_Filename, Width_Line, 
				     Max_Words, Samples_Max, Network_Filename, Lines, Cols, Classe, 
				     
				     window);
   
   
   
   task type Auth_Process (Center : access Center_Record) is
      entry Auth;
      entry Halt;
   end Auth_Process;
   
   type Auth_Record is tagged
      record
	 Logname    : String_Access;
	 Password   : Sha1.Message_Digest;	 
      end record;      
   
   
   
   type Multi_Enum is (Command_Mode, Edit_Mode,  Account_Mode, Shell_Mode);
   
   
   
   
   task type Dialog_Process (Center : access Center_Record) is
      pragma Storage_Size (268435456);
      
      entry Halt;
      entry Initialize(User_Text : in Wide_String);
      entry Receive (Wchar : in Wide_Character);      
      entry Reset;      
      entry Lock;
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Shutdown;
      entry Wake_Up;
      entry New_Evidence;
   private
      entry Dialog;
   end Dialog_Process;
   
   
   type Devel_Enum is (Command, Document, Web_Search);
   
   task type Devel_Process (Center : access Center_Record; Lines_Max : Positive) is
      entry Halt;
      entry Initialize;
      entry Receive (Wchar : in Wide_Character);
      entry Switch (Mode : in Devel_Enum);
      entry Mode (Mode : out Devel_Enum);
      entry Reset;      
      entry Lock;
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Shutdown;
      entry Wake_Up;
      entry New_Evidence;
      entry New_Ranking(Objects : Rank_Array);
   end Devel_Process;
      
   
   task type Organizer_Process (Center : access Center_Record) is
      entry Halt (End_Of_Program : out Boolean);
      entry Initialize;
      entry Receive (Wchar : in Wide_Character);      
      entry New_Goal;
      entry Goal_Path_Tree_View;
      entry Add_Goal_Path;
      entry Reset;
      entry Lock;
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Shutdown;
      entry Wake_Up;
   end Organizer_Process;
   
   
   --  task type Tasking_Process (Center : access Center_Record) is
   --     entry Halt (End_Of_Program : out Boolean);
   --     entry Initialize (Mode : Mode_Enum);
   --     entry Receive (Wchar : in Wide_Character);
   --     entry Mode(Mode : out Mode_Enum);
   --     entry Reset;
   --     entry Switch (Mode : in Mode_Enum);
   --     entry Lock;
   --     entry Unlock;
   --     entry Set_On_Esc(Is_Escape : in Boolean);      
   --     entry Page_Down;
   --     entry Page_Up;
   --     entry Up_Arrow;
   --     entry Down_Arrow;
   --     entry Left_Arrow;
   --     entry Right_Arrow;
   --     entry Full_Screen;
   --     entry Del;
   --     entry Begin_Of;
   --     entry End_Of;
   --     entry Overwrite;
   --     entry Screen_Print;
   --     entry Shutdown;
   --     entry Wake_Up;
   --  end Tasking_Process;
   
   
   --  task type Editor_Process (Center : access Center_Record) is
   --     entry Halt (End_Of_Program : out Boolean);
   --     entry Initialize (Mode : Mode_Enum);
   --     entry Receive (Wchar : in Wide_Character);
   --     entry Mode(Mode : out Mode_Enum);
   --     entry Reset;
   --     entry Switch (Mode : in Mode_Enum);
   --     entry Lock;
   --     entry Unlock;
   --     entry Set_On_Esc(Is_Escape : in Boolean);      
   --     entry Page_Down;
   --     entry Page_Up;
   --     entry Up_Arrow;
   --     entry Down_Arrow;
   --     entry Left_Arrow;
   --     entry Right_Arrow;
   --     entry Full_Screen;
   --     entry Del;
   --     entry Begin_Of;
   --     entry End_Of;
   --     entry Overwrite;
   --     entry Screen_Print;
   --     entry Shutdown;
   --     entry Wake_Up;
   --  end Editor_Process;
   
   
   task type Command_Process (Center : access Center_Record) is
      entry Halt;
      entry Initialize;
      entry Receive (Wchar : in Wide_Character);
      entry Reset;
      entry Lock;
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Wake_Up;
   end Command_Process;
   
   
   --  task type Account_Process (Center : access Center_Record) is
   --     entry Halt (End_Of_Program : out Boolean);
   --     entry Initialize (Mode : Mode_Enum);
   --     entry Receive (Wchar : in Wide_Character);
   --     entry Mode(Mode : out Mode_Enum);
   --     entry Reset;
   --     entry Switch (Mode : in Mode_Enum);
   --     entry Lock;
   --     entry Unlock;
   --     entry Set_On_Esc(Is_Escape : in Boolean);      
   --     entry Page_Down;
   --     entry Page_Up;
   --     entry Up_Arrow;
   --     entry Down_Arrow;
   --     entry Left_Arrow;
   --     entry Right_Arrow;
   --     entry Full_Screen;
   --     entry Del;
   --     entry Begin_Of;
   --     entry End_Of;
   --     entry Overwrite;
   --     entry Screen_Print;
   --     entry Shutdown;
   --     entry Wake_Up;
   --  end Account_Process;
   
   
   task type Multi_Process (Center : access Center_Record) is
      entry Halt;
      entry Initialize;
      entry Receive (Wchar : in Wide_Character);      
      entry Reset;
      entry Mode (Mode : out Multi_Enum);
      entry Switch (Mode : in Multi_Enum);
      entry Lock;
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Shutdown;
      entry Wake_Up;
   end Multi_Process;
   
   
   --  task type Execut_Process (Center : access Center_Record) is
   --     entry Halt;
   --     entry Initialize;
   --     entry Receive (Wchar : in Wide_Character);
   --     entry Reset;
   --     entry Lock;
   --     entry Unlock;
   --     entry Set_On_Esc(Is_Escape : in Boolean);      
   --     entry Page_Down;
   --     entry Page_Up;
   --     entry Up_Arrow;
   --     entry Down_Arrow;
   --     entry Left_Arrow;
   --     entry Right_Arrow;
   --     entry Full_Screen;
   --     entry Del;
   --     entry Begin_Of;
   --     entry End_Of;
   --     entry Overwrite;
   --     entry Screen_Print;
   --     entry Shutdown;
   --     entry Wake_Up;
   --  end Execut_Process;
   
   
   
   
   
   task type Shell_Process (Center : access Center_Record) is
      entry Halt;
      entry Initialize (Dialup : Dialup_Enum);
      entry Receive (Wchar : in Wide_Character);
      entry Mode(Mode : out Mode_Enum);
      entry Reset;
      entry Switch (Dialup : in Dialup_Enum);
      entry Lock;
      entry Unlock;
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      entry Shutdown;
      entry Wake_Up;
   end Shell_Process;
   
   
   task type Astar_Process (Center : access Center_Record) is
      entry Search_Path (Open : in Classes.Abstracted_Access;
   			 Goal : in Classes.Abstracted_Access);
      entry Goal_Path(Path : in out Classes.Abstracted_Vectors.Vector);
      entry Halt;
   end Astar_Process;
   
   
   
   use Config;
   use Config.Server;
   use Config.Server.Engine;
   use Config.Server.Engine.Intelligency;
   use Config.Server.Engine.Intelligency.Cyborg;
   use Config.Server.Engine.Intelligency.Cyborg.Hander;
   use Words_Glossary;
   use Classes;
   
   package Elhoim is new El.Elhoim (Classes, Config.Server.Engine);
   use Elhoim;
      
   
   
   
   
	 
   
   
   use Config.Server.Engine.Intelligency.Cyborg.Hander.Neural_Retrain;
   type Internal_Cmd_Enum is (Null_Cmd, Clear, Cd, Pwd, Logout, Help, Alias, Unalias);
   
   type Center_Record is new Config.Config_Record with
      record
	 Header_Win   : Window_Record;
	 Main_Win     : Window_Record;	 
	 Msg_Win      : Window_Record;

	 Center_Proc  : Center_Process (Center_Record ' access);
	 Work_Proc    : Work_Process (Center_Record ' access);
	 Console_Proc : Console_Process (Center_Record ' access);
	 Auth_Proc    : Auth_Process (Center_Record  ' access );
	 
	 Global_Lock  : Binary_Semaphore (True, Default_Ceiling);
	 
	 Terminal     : Term_Enum := Linux;
	 Prev_Mode    : Mode_Enum := Null_Mode;
	 Current_Mode : Mode_Enum := Auth_Mode;
	 Prev_Multi   : Multi_Enum := Command_Mode;
	 Full_Screen : Boolean := False;
	 On_Esc        : Boolean := False;
	 Visitors      : Users_Ptr := new User_set(4);	 
	 User_Auth     : Auth_Record;
	 User          : User_Access;
	 User_Ready    : Boolean := False;
	 
	 Full_Shell_Filename : Os_Lib.String_Access;
	 
	 Frames      : Frame_Set;
	 
	 
	 Given_Username : Wide_String_Access;
	 Given_Hostname : Wide_String_Access;
	 Given_Text     : Wide_String_Access;
	 -----------------------------------------
	 --       Neural network variables      --
	 -----------------------------------------
	 Set_Filename : access String := new String ' ("samples_set.txt");
	 User_Text    : Wide_String_Access;
	 
	 
	 -----------------------------------------------------------
	 --                     Others process                    --
	 -----------------------------------------------------------
	 
	 -----------------------------------------
	 --          Shell Process              --
	 -----------------------------------------
	 Shell_Proc   : Shell_Process (Center_Record ' access);	 
	 Shell_Result : Wide_Result_Access;
	 
	 Shells : access Shells_Record;	 
	 -----------------------------------------
	 --          Execut Process             --
	 -----------------------------------------
	 --Execut_Proc   : Execut_Process (Center_Record ' access);	 
	 Current_Exec : Dialup_Enum := Sys;
	 
	 
	 -----------------------------------------
	 --          Devel Process              --
	 -----------------------------------------
	 Devel_Proc   : Devel_Process (Center_Record ' access, 2**14);	 
	 Current_Doc  : Docume_Access;
	 Doc_Initialized  : Boolean := False;
	 Players      : Players_Ptr;
	 Player       : Player_Access;
	 
	 
	 -----------------------------------------
	 --          Editor Process              --
	 -----------------------------------------
	 --Editor_Proc   : Editor_Process (Center_Record ' access);	 
	 
	 -----------------------------------------
	 --          Dialog Process             --
	 -----------------------------------------
	 Dialog_Proc      : Dialog_Process (Center_Record ' access);	 
	 
	 --          Shared with Organizer      --
	 Wline            : Wide_String_Access := new Wide_String ' ("");
	 Wbuffer          : Wide_String_Access;
	 Current_Pos      : Natural := 1;      
	 Wline_Length     : Natural := 0;
	 Word_Number      : Word_Range := 0;
	 Dialog_Response         : Wide_String_Access := new Wide_String ' ("");
	 Response_Buffer  : Wide_String_Set(1); 
	 Internal         : Wide_String_Access := new Wide_String ' ("");
	 internal_Buffer  : Wide_String_Set(1); 
	 
	 
	 ----------------------------------------------
	 --         Common network variables         --
	 ----------------------------------------------
	 Input            : Input_Type;
	 Output           : Output_Type;
	 Feedback         : Output_Type;-- := String2input(To_String(Preuve));
	 Samples_Set      : aliased Neural_Train.Sample_Set_Type;
	 Samples          : aliased Neural_Retrain.Sample_Set_Type;
	 Words            : Glossary_Type;
	 
	 
	 -----------------------------------------
	 --         Organizer Process           --
	 -----------------------------------------
	 User_Filename : Strings.String_Access := new String ' ("user_objects_file.txt");
	 Ai_Filename : Strings.String_Access := new String ' ("ai_objects_file.txt");
      
	 State_Index : Natural := 0;
	 Ai_Index : Natural := 0;
     
	 Expr_List : Expr_Vectors.Vector;	    
	 Expr : Expression_Type := (others => Wide_Character'Val(32));
	 Expr_Index : Natural := 0;
	 
	 Prompt_List : Prompt_Vectors.Vector;
	 Prompt : Name_Type := ("Subject         ");
	 Astar_Proc      : Astar_Process (Center_Record ' access);
	 Goal_Path_Search_End_Of_Task : Boolean := True;
	 
	 View_Is_Goal_Path : Boolean := False;
	 Goal_Path_Lock  : Binary_Semaphore (True, Default_Ceiling);
	 Organizer_Proc   : Organizer_Process (Center_Record ' access);	 
	 
	 -----------------------------
	 --     Goal terminals      --
	 Goal_T : Terminal_Access;
	 --Ai : Terminal_Record;      --
         --                         --
         -----------------------------
	 Object_Is_Goal : Boolean := False;
	 Goal        : Classes.Abstracted_Access;
	 Start_Node  : Classes.Abstracted_Access;
	 Goal_Path   : Classes.Abstracted_Vectors.Vector;
	 
	 Path_Lock  : Binary_Semaphore (True, Default_Ceiling);
	 -----------------------------------------
	 --          Multi Process              --
	 -----------------------------------------
	 Multi_Proc   : Multi_Process (Center_Record ' access);	 
	 Multi_Mode         : Multi_Enum := Command_Mode;
	 Previsious_Multi   : Multi_Enum := Account_Mode;
	 
	 -----------------------------------------
	 -- Common variables for Multi & Devel  --
	 -----------------------------------------
	 Prev_Cmd : Wide_String_Access := new Wide_String ' ("");
	 Prev_Arg : Wide_String_Access := new Wide_String ' ("");
	 
	 Cmd : Wide_String_Access;
	 arg : Wide_String_Access;
	 Command_Last : Natural;
      
	 Devel_Spawn_Result       : Wide_Result_Access;
	 Multi_Spawn_Result       : Wide_Result_Access;
	 
	 Line_Index : Natural := 0;
	 File_Index : Natural := 0;      
	 Result_Max_Lines : Natural := 0;	 
	 Completion_Result : Wide_Result_Access;
      	 	 
	 -----------------------------------------
	 --          Command Process            --
	 -----------------------------------------
	 Command_Proc   : Command_Process (Center_Record ' access);	 
	 Logout         : Boolean := False;
	 -----------------------------------------
	 --          Tasking Process            --
	 -----------------------------------------
	 --Tasking_Proc   : Tasking_Process (Center_Record ' access);	 
	 
	 -----------------------------------------
	 --          Account Process            --
	 -----------------------------------------
	 --Account_Proc   : Account_Process (Center_Record ' access);	 
	 
	 -----------------------------------------
	 --          Server process             --
	 -----------------------------------------
	 -----------------------------------------
	 --            Others data              --
	 -----------------------------------------
	 
	 User_Path     : Os_Lib.String_Access;
	 
	 Domain : Ai_Domain_Record (1024);
	 Classes_Ranking : access El.Rank_Array;
	 	 
	 
	 T  : aliased Terminal_Record;
	 Ai : aliased Terminal_Record;
	 
	 
	 Elhoim_Task : access Elhoim.Elhoim_Task;
	 
      end record;
   procedure Initialize (Center : in out Center_Record; Users_Max : in Positive; Lexic_Filename : in String);
   function Get_Lines (Int : in Center_Record) return Positive;
   function Get_Cols (Int : in Center_Record) return Positive;

end El.Center ; 
