-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with Ada.Unchecked_Deallocation;
package M.Strings is
type Wide_String_Access is access all Wide_String;
   procedure Wide_Free is new Ada.Unchecked_Deallocation (Wide_String, Wide_String_Access);
   
   subtype Line_Index_Range is Natural range 0..132072;
   type Wide_String_Array is array (Line_Index_Range range <>) of Wide_String_Access;
   type Wide_String_Set (Lines_Max : Line_Index_Range) is tagged
      record
	 Lines : Wide_String_Array(1..Lines_Max);
	 Line_Last : Natural := 0;	     
      end record;   
   
   procedure Add_Line (Set : in out Wide_String_Set;
		       Last : in out Line_Index_Range;
		       Line : in Wide_String);
   procedure Set_Free(Set : in out Wide_String_Set);

end M.Strings ; 
