-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 11:53:09"
-- Version := "0.0.0r"
package M.Parameters is
   
      type Parameter_Record (Requiered_Parameter : Boolean) is tagged
      record	 
	 Switch   : access Wide_String;	 	 
	 Num_Iter : Natural := 0;	 	 
	 Is_Setted : Boolean := False;	 
	 Parameter_Flag : Flag_Enum := None;	 
	 Descr : access Wide_String;	 
	 case Requiered_Parameter is
	    when False =>
	       null;
	    when True =>
	       
	       param : access Wide_String;
	       Value : access Wide_String;
	 end case;
      end record;
   
   type Parameters_Kit is 
     array (Flag_Enum) of 
     access Parameter_Record;
   
   
   Line_Parameters : constant Parameters_Kit := 
     (
      
      None => null,
      Config_Filename => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Help => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      Quiet => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("q"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Quiet, 
	 Descr => new Wide_String ' ("quiet option")),
      Version => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      Initialize => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Initialize, 
	 Descr => new Wide_String ' ("initiaize total value"),
	 Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	 Value => null),
      Total => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Total, 
	 Descr => new Wide_String ' ("print fixed from -999999.99 to 999999.99")),
      Geometry => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => geometry, 
	 Descr => new Wide_String ' ("Descibe the term geometry ; (eg : 67x240)"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      style => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => style, 
	 Descr => new Wide_String ' ("style"),
	 Param => new Wide_String ' ("string : Black_And_White, Black_And_Color, Color_And_White" &
				       Wide_Character'Val(10) &
				       "                       White_And_Color, Color_And_Color, White_And_White"),
	 Value => null),
            Samples_Filename => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("f"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag =>  Samples_filename, 
	 Descr => new Wide_String ' ("Samples filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Max_epochs => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("m"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Max_Epochs, 
	 Descr => new Wide_String ' ("Max_Epochs"),
	 Param => new Wide_String ' ("Integer"),
	 Value => null),
      Converged => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Converged, 
	 Descr => new Wide_String ' ("Converged"),
	 Param => new Wide_String ' ("Real number"),
	 Value => null),
      Reuse => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Reuse, 
	 Descr => new Wide_String ' ("Reuse")),	 
      Train => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Train, 
	 Descr => new Wide_String ' ("Train")),
      Num_samples => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_Samples, 
	 Descr => new Wide_String ' ("Num_Samples"),
	 Param => new Wide_String ' ("Integer"),
	 Value => null),      
      Line_Width => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Line_Width, 
	 Descr => new Wide_String ' ("Line_Width"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
            Char_Max => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Char_Max,
	 Descr => new Wide_String ' ("Line length max"),
	 Param => new Wide_String ' ("Char_Index_Type"),
	 Value => null),

      Words_Max => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("L"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Words_Max, 
	 Descr => new Wide_String ' ("Words_Max"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Num_hidden => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("H"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_hidden, 
	 Descr => new Wide_String ' ("Num_hidden"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Update => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Update, 
	 Descr => new Wide_String ' ("update"),
	 Param => new Wide_String ' ("string"),
	 Value => null),
      As_server => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => As_server, 
	 Descr => new Wide_String ' ("As server")),
      Term_Name => new Parameter_Record '
      	(Requiered_Parameter => True, Switch => new Wide_String ' ("N"), Num_Iter => 0,
      	 Is_Setted => False, Parameter_Flag => Term_Name, 
      	 Descr => new Wide_String ' ("Terminal name"),
      	 Param => new Wide_String ' ("String"),
      	 Value => null),

      Self_Programming => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("p"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Programming,
	 Descr => new Wide_String ' ("Self programming"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Executed => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Executed,
	 Descr => new Wide_String ' ("Self Executed"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Wait => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("w"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Wait,
	 Descr => new Wide_String ' ("Self wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
            Username => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Username, 
	 Descr => new Wide_String ' ("user name"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Address => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("A"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Address, 
	 Descr => new Wide_String ' ("remote address"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Input_Text => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Input_Text, 
	 Descr => new Wide_String ' ("input text"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Name_Length => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Name_Length,
	 Descr => new Wide_String ' ("Name length max"),
	 Param => new Wide_String ' ("Name_Index_Type"),
	 Value => null),
      Unit_Max => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Unit_Max,
	 Descr => new Wide_String ' ("Units max"),
	 Param => new Wide_String ' ("Unit_Index_Type"),
	 Value => null),
      Object_Max => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("o"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Object_Max, 
	 Descr => new Wide_String ' ("Object max"),
	 Param => new Wide_String ' ("Object_index_type"),
	 Value => null),

      User_wait => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => User_Wait,
	 Descr => new Wide_String ' ("User wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
      Human_Lang => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Human_Lang, 
	 Descr => new Wide_String ' ("Human Language I18 abrev"),
	 Param => new Wide_String ' ("Human_Lang_Enum"),
	 Value => null),
      With_Gtk => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Gtk, 
	 Descr => new Wide_String ' ("with GtkAda"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Ada => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Ada, 
	 Descr => new Wide_String ' ("with Ada"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Aws => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Aws, 
	 Descr => new Wide_String ' ("with AWS"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null)

	
     );
   
   File_Parameters : constant Parameters_Kit := 
     (
      
            None => null,
      Config_Filename => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Help => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      Quiet => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("q"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Quiet, 
	 Descr => new Wide_String ' ("quiet option")),
      Version => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      Initialize => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Initialize, 
	 Descr => new Wide_String ' ("initiaize total value"),
	 Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	 Value => null),
      Total => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Total, 
	 Descr => new Wide_String ' ("print fixed from -999999.99 to 999999.99")),
      Geometry => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => geometry, 
	 Descr => new Wide_String ' ("Descibe the term geometry ; (eg : 67x240)"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      style => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => style, 
	 Descr => new Wide_String ' ("style"),
	 Param => new Wide_String ' ("string : Black_And_White, Black_And_Color, Color_And_White" &
				       Wide_Character'Val(10) &
				       "                       White_And_Color, Color_And_Color, White_And_White"),
	 Value => null),
            Samples_Filename => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("f"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag =>  Samples_filename, 
	 Descr => new Wide_String ' ("Samples filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Max_epochs => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("m"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Max_Epochs, 
	 Descr => new Wide_String ' ("Max_Epochs"),
	 Param => new Wide_String ' ("Integer"),
	 Value => null),
      Converged => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Converged, 
	 Descr => new Wide_String ' ("Converged"),
	 Param => new Wide_String ' ("Real number"),
	 Value => null),
      Reuse => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Reuse, 
	 Descr => new Wide_String ' ("Reuse")),	 
      Train => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Train, 
	 Descr => new Wide_String ' ("Train")),
      Num_samples => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_Samples, 
	 Descr => new Wide_String ' ("Num_Samples"),
	 Param => new Wide_String ' ("Integer"),
	 Value => null),      
      Line_Width => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Line_Width, 
	 Descr => new Wide_String ' ("Line_Width"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
            Char_Max => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Char_Max,
	 Descr => new Wide_String ' ("Line length max"),
	 Param => new Wide_String ' ("Char_Index_Type"),
	 Value => null),

      Words_Max => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("L"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Words_Max, 
	 Descr => new Wide_String ' ("Words_Max"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Num_hidden => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("H"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_hidden, 
	 Descr => new Wide_String ' ("Num_hidden"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Update => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Update, 
	 Descr => new Wide_String ' ("update"),
	 Param => new Wide_String ' ("string"),
	 Value => null),
      As_server => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => As_server, 
	 Descr => new Wide_String ' ("As server")),
      Term_Name => new Parameter_Record '
      	(Requiered_Parameter => True, Switch => new Wide_String ' ("N"), Num_Iter => 0,
      	 Is_Setted => False, Parameter_Flag => Term_Name, 
      	 Descr => new Wide_String ' ("Terminal name"),
      	 Param => new Wide_String ' ("String"),
      	 Value => null),

      Self_Programming => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("p"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Programming,
	 Descr => new Wide_String ' ("Self programming"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Executed => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Executed,
	 Descr => new Wide_String ' ("Self Executed"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Wait => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("w"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Wait,
	 Descr => new Wide_String ' ("Self wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
            Username => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Username, 
	 Descr => new Wide_String ' ("user name"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Address => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("A"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Address, 
	 Descr => new Wide_String ' ("remote address"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Input_Text => new Parameter_Record '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Input_Text, 
	 Descr => new Wide_String ' ("input text"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Name_Length => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Name_Length,
	 Descr => new Wide_String ' ("Name length max"),
	 Param => new Wide_String ' ("Name_Index_Type"),
	 Value => null),
      Unit_Max => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Unit_Max,
	 Descr => new Wide_String ' ("Units max"),
	 Param => new Wide_String ' ("Unit_Index_Type"),
	 Value => null),
      Object_Max => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("o"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Object_Max, 
	 Descr => new Wide_String ' ("Object max"),
	 Param => new Wide_String ' ("Object_index_type"),
	 Value => null),

      User_wait => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => User_Wait,
	 Descr => new Wide_String ' ("User wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
      Human_Lang => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Human_Lang, 
	 Descr => new Wide_String ' ("Human Language I18 abrev"),
	 Param => new Wide_String ' ("Human_Lang_Enum"),
	 Value => null),
      With_Gtk => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Gtk, 
	 Descr => new Wide_String ' ("with GtkAda"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Ada => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Ada, 
	 Descr => new Wide_String ' ("with Ada"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Aws => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Aws, 
	 Descr => new Wide_String ' ("with AWS"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null)

	

     );


   type Parameters_Kit_Record is tagged
      record
	 Kit : Parameters_kit;
	 Name_Length : Name_Index_Type := 1024;
	 Unit_Max    : Unit_Index_Type := 1024;
	 With_Gtk : Boolean := False;
	 With_Ada : Boolean := False;
	 With_Aws : Boolean := False;
	 Char_Max	: char_index_type := 256;
	 Version        : version_index_type := 2016;
	 Objects_Max : Object_Index_Type := 65536;	 
	 Self_Programming	: boolean := False;
	 Self_Executed		: boolean := False;	 
	 Self_Wait : Duration := 0.00005;
	 User_Wait : Duration := 86400.0;
	 Human_Lang : Human_Lang_Enum := Human_Lang_Enum'First;
      end record;

end M.Parameters ; 
