-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-15 07:04:36 ; 
-- Version := 0.10.0a ; 
with Sky;
use Sky;
with M.Strings;
use M.Strings;
use M;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
package M.Main_game is
   type Product_Class is tagged
      record
	 Name : String_Access;
	 Description : Wide_String_Access;
	 Documentation : String_Access;
	 unit_Ht : Fixed_Unit_Ht := 0.0;
	 TVA_Rate : Fixed_Factor := 0.0;
	 TVA : Fixed_Total := 0.0;
	 Unit_Ttc : Fixed_Unit_Ttc := 0.0;
      end record;
   
   type Product_Access is access all Product_Class;
   
   type Product_Table is array (Positive range <>) of Product_Access;
   
   type Main_Game(Max_Product : Positive) is
      record
	 Products : Product_Table(1..Max_Product);
	 Count : Natural := 0;
      end record;

end M.Main_game ; 
