-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-07-25 08:23:49 ; 
-- Version := 0.4.0r ; 
with Ada.Containers.Vectors;
use Ada.Containers;
with M.Ansi.Windows;
with Ada.Calendar;
use Ada.Calendar;
with M.Strings;
use M.Strings;
with Ada.Wide_Text_Io;
with M.Attributes;
use M.Attributes;
generic
   with package My_Windows is new M.Ansi.Windows (<>);
package M.Engine is
   
   use My_Windows;
   
   package W_Io renames Ada.Wide_Text_Io;
   
   type Element_Index is new Positive;
   
   type Element_Class(Tag : Element_Enum);
   
   type Element_Access is access all Element_Class'Class;
   
   procedure Obj_Free(O : in out Element_Access);
   
   
   function Same (Left, Right : in Element_Access) return Boolean;
   package Element_Vectors is new Vectors (Element_Index, Element_Access, Same);
   
   type Element_Info(Tag : Element_Enum) is
      record
	 Index   : Element_Index := 1;
	 Name    : Wide_String_Access;
	 Created : Time := Time_Of(1970, 1, 1, 0.0);
	 Childs_Num : Natural := 0;
      end record;
   
   type Wide_Set_Access is access all Wide_String_Set;
   
   type Element_Class(Tag : Element_Enum) is abstract tagged
      record
	 
	 Info : Element_Info(Tag);
	 
	 Childs  : Element_Vectors.Vector;
	 
	 Definition : Attributs(10);
	 case Tag is
	    when None =>
	       null;
	    when License =>
	       License : Wide_Set_Access;
	    when others =>
	       Line : Wide_String_Access;
	 end case;
      end record;
   
   procedure Print (Info : Element_Info; header : in Window_Type);
   
   procedure Print (Obj    : in Element_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is abstract;
   
   procedure Write (O : in Element_Class;File : in W_Io.File_Type) is abstract;
   procedure Read (O : out Element_Class;File : in W_Io.File_Type) is abstract;

   
   procedure Print (Attr : in Attributs; Win : in Window_type);
   
   type None_Class is new Element_Class(None) with null record;
   
   
   procedure Print (Obj    : in None_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in None_Class;File : in W_Io.File_Type);
   procedure Read (O : out None_Class;File : in W_Io.File_Type);
   
   type Program_Class is new Element_Class(Program) with null record;
   
   
   procedure Print (Obj    : in Program_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Program_Class;File : in W_Io.File_Type);
   procedure Read (O : out Program_Class;File : in W_Io.File_Type);

   
   type Description_Class is new Element_Class(Description) with null record;
   
   procedure Print (Obj    : in Description_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Description_Class;File : in W_Io.File_Type);
   procedure Read (O : out Description_Class;File : in W_Io.File_Type);
   
   type License_Class is new Element_Class(License) with null record;
   
   procedure Print (Obj    : in License_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in License_Class;File : in W_Io.File_Type);
   procedure Read (O : out License_Class;File : in W_Io.File_Type);
   
   
   
   
   type Main_Class is new Element_Class(Main) with null record;
   
   procedure Print (Obj    : in Main_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Main_Class;File : in W_Io.File_Type);
   procedure Read (O : out Main_Class;File : in W_Io.File_Type);
   
   
   
   
   
   type Library_Class is new Element_Class(Library) with null record;
   procedure Print (Obj    : in Library_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Library_Class;File : in W_Io.File_Type);
   procedure Read (O : out Library_Class;File : in W_Io.File_Type);
   
   
   
   type Axiomatic_Class is new Element_Class(Axiomatic) with null record;
   
   procedure Print (Obj    : in Axiomatic_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   
   procedure Write (O : in Axiomatic_Class;File : in W_Io.File_Type);
   procedure Read (O : out Axiomatic_Class;File : in W_Io.File_Type);
   
   
   type Axiom_Class is new Element_Class(Axiom) with null record;
   
   procedure Print (Obj    : in Axiom_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Axiom_Class;File : in W_Io.File_Type);
   procedure Read (O : out Axiom_Class;File : in W_Io.File_Type);
   
   
   type Predicate_Class is new Element_Class(Predicate) with null record;
   
   procedure Print (Obj    : in Predicate_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Predicate_Class;File : in W_Io.File_Type);
   procedure Read (O : out Predicate_Class;File : in W_Io.File_Type);
   
   type Precondition_Class is new Element_Class(Precondition) with null record;
   
   procedure Print (Obj    : in Precondition_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Precondition_Class;File : in W_Io.File_Type);
   procedure Read (O : out Precondition_Class;File : in W_Io.File_Type);
   
   type Condition_Class is new Element_Class(Condition) with null record;
   
   procedure Print (Obj    : in Condition_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Condition_Class;File : in W_Io.File_Type);
   procedure Read (O : out Condition_Class;File : in W_Io.File_Type);
   
   type Component_Class is new Element_Class(Component) with null record;
   
   procedure Print (Obj    : in Component_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Component_Class;File : in W_Io.File_Type);
   procedure Read (O : out Component_Class;File : in W_Io.File_Type);
   
   type Action_Class is new Element_Class(Action) with null record;
   
   procedure Print (Obj    : in Action_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Action_Class;File : in W_Io.File_Type);
   procedure Read (O : out Action_Class;File : in W_Io.File_Type);
   
   type Class_Class is new Element_Class(Class) with null record;
   
   procedure Print (Obj    : in Class_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Class_Class;File : in W_Io.File_Type);
   procedure Read (O : out Class_Class;File : in W_Io.File_Type);
   
   type Machine_Class is new Element_Class(Class) with null record;
   
   procedure Print (Obj    : in Machine_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in Machine_Class;File : in W_Io.File_Type);
   procedure Read (O : out Machine_Class;File : in W_Io.File_Type);
   
   type System_Class is new Element_Class(Class) with null record;
   
   procedure Print (Obj    : in System_Class;
		    Header : in Window_Type;
		    Win : in Window_Type);
   
   procedure Write (O : in System_Class;File : in W_Io.File_Type);
   procedure Read (O : out System_Class;File : in W_Io.File_Type);
   
end M.Engine ; 
