-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-14 07:53:20"
-- Version := "4.0.0r"
with Ada.Calendar.Formatting;
use Ada.Calendar;
with Text_Io;
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
use Ada.Strings;
package body Work.Classes.Event_Class is
   
   function Fit (Event : in Event_Obj) return Float is
   begin
      return 0.0;
   end Fit;
   
   procedure Mutate(Event : in out Event_Obj) is
   begin
      Event.Event.date := Event.Event.Date + 2.0;
   end Mutate;
   
   function Mute(Left : in Event_Obj; 
		 Right : in Object_Class'class) return Event_Obj is
      O : Event_Obj;      
   begin
      O.Event.Date := Clock + 2.0;
      return O;
   end Mute;
           
   procedure Write (O : in Event_Obj;File : in T_Io.File_Type) is
   begin
      null;
   end Write;
   
   procedure Read (O : in out Event_Obj;File : in T_Io.File_Type) is
      Elapsed_Time : String_Access;
   begin
      O.Event.Tag := new String ' (Text_Io.Get_Line(File));

      O.Event.Date := Formatting.Value(Text_Io.Get_Line(File));

      Elapsed_Time := new String ' (Text_Io.Get_Line(File));

      O.Event.D := Duration(Float'Value(Elapsed_Time.all));

   end Read;
   
   procedure Print (O : in Event_Obj) is
   begin
      Text_Io.Put_Line("Event : " & Formatting.Image(O.Event.Date));
   end Print;
   procedure Print (O : in Event_Obj; Win : in Window_Record; Index : in out Natural) is
   begin
      if Index + 3 >= Win.Win.H-2 then return; end if;
      if O.Event.Tag /= null then
	 Index := Index + 1;
	 Draw_Text(Win, Index, 1, Cyan, To_Wide_String("Event : " & O.Event.Tag.all));
      end if;
      Index := Index + 1;
      Draw_Text(Win, Index, 1, Cyan, To_Wide_String("Event date : " & Formatting.Image(O.Event.Date)));
      Index := Index + 1;
      Draw_Text(Win, Index, 1, Cyan, To_Wide_String("Duration : " & Formatting.Image(O.Event.D)));
      
   end Print;

end Work.Classes.Event_Class ; 
