-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package El.Projec is
   
      type Abstract_Project_Type is tagged
      record
	 Name : Strings.string_access;
	 Description : wide_string_access;
      end record;
	
   type Abstract_Project_Access is access all Abstract_Project_Type'Class;
	
   type Abstract_Data_Type is abstract tagged
      record
	 Project : Abstract_Project_Access;
      end record;
   
   type Abstract_Object is abstract tagged null record;
   
   type Object_Access is access all Abstract_Object'Class;
   
   
   
   type Object_Index_Type is new Natural range 0..Objects_Max;
   
   type Objects_Array_Type is array (Object_Index_Type range <>) of Object_Access;
   
     
   type Objects_Context_Record is new Language_Context_Record with
      record
	 Objects_Params : Parameters.Objects_Parameters_Type := Objects.Params;
	 Objects_Table  : Objects_Array_Type(1..Object_Index_Type'Last);
	 Object_Index   : Object_Index_Type := 0;
      end record;
   
   
   procedure initialize(Objects_Context : in out Objects_Context_Record;
			Objects_Params  : in Objects_Parameters_Type);
   
   procedure Load_project(Objects_Context : in out Objects_Context_Record;			
			Ada_Path : in String;
			Gtk_Path : in String;
			Aws_Path : in String;
			Project_Path : in String);
   
   --  function Check_Parameters(Objects_Context : in Objects_Context_Record'Class;
   --  			    Params : in Objects_Parameters_Type'class) return Boolean;
   

   type Object_unit_record is new Language_unit_record with
      record
	 null;
      end record;
   type Object_Unit_Access is access all Language_Unit_record;
   type Objects_set_array_type is array (Positive) of Language_Unit_Access;
   type objects_set_access is access Language_Set_array_type;
   type objects_System is new Language_System with
	record
		Index : Natural := 0;
		Objects_set : Objects_set_access;
	end record;
   
   
   type Project_Class is new Abstract_Project_Type with
      record
	 Authors : Wide_String_Access;
	 Copyright : Wide_String_Access;
      end record;
   
   type Data_Class is new Abstract_DAta_Type with null record;
   
   type Gnose_Project_Type is new Project_Class with null record;
   
   procedure Initialize

     (
      Data : in out Data_Class;
      Project : in Gnose_Project_Type
     );
   
   
   use Parameters;
   package Agnose_Projects is new Gnos.Projects(Projects_Parameters_Type(params));
   Machines_Params : Parameters.Language_Parameters_Type := Params;
   
   use Projec;

   
   type Language_Context_Record is new Projects_Context_Record with
      record
	 Language_Params  : Parameters.Language_Parameters_Type := Machines.Params;	 
      end record;

   
   procedure initialize(Language_Context : in out Language_Context_Record;
			Language_Params  : in Language_Parameters_Type);			
   procedure Load_project(Language_Context : in out Language_Context_Record;			
			Ada_Path : in String;
			Gtk_Path : in String;
			Aws_Path : in String;
			Project_Path : in String);
   
   function Check_Parameters(Language_Context : in Language_Context_Record'class;
			     Params : in Language_Parameters_Type'class) return Boolean;      
	

    type Language_unit_record is tagged
	record
	   Machine_Lang : Machine_Lang_Enum := Machine_Lang_Enum'First;
	end record;
   type Language_Unit_Access is access all Language_Unit_record;
   type Language_set_array_type is array (Machine_Lang_Enum range <>) of Language_Unit_Access;
   type Language_set_access is access Language_Set_array_type;
   type Language_System is tagged
      record	 
	 Language_set : Language_set_access;
      end record;
   
   procedure Load_Language(Language_Set : in out Language_Set_Array_Type; Machine_Lang : in Machine_Lang_Enum);

end El.Projec ; 
