-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with PragmARC.Rem_Nn_Wrapper;
use PragmARC.Rem_Nn_Wrapper;

package El.Neural is
   
   generic
      Num_Inputs  : Positive;
      Num_Hiddens : Positive;
      Num_Outputs : Positive;
      Max_Samples : Positive;   
      Filename    : String;
   package Neuro_Process is
      
      
      
      use PragmARC.Rem_NN_Wrapper;      
      
      subtype Normal_Type is Real range Real'First..Real'Last;
      
      type Input_Type is array (Positive range 1..Num_Inputs) of Normal_Type;
      type Output_Type is array (Positive range 1..Num_Outputs) of Normal_Type;
      
      type Sample_Type is
	 record
	    Input  : Input_Type  := (others => 0.0);
	    Output : Output_Type := (others => 0.0);
	 end record;
      
      type Sample_Set_Type is array (Positive range 1..Max_Samples) of Sample_Type;
      
      
      procedure Train     (Samples    : access Sample_Set_Type;
			   Max_Epochs : in     Positive;
			   Converged  : in     Normal_Type;		
			   Reuse      : in     Boolean;
			   RMS_Error  :    out Normal_Type);
      
      
      task type Request_NN is
	 pragma Storage_Size(2128451647);
	 entry  respond  (Input       : in     Input_Type;
			  Response    :    out Output_Type);
      end Request_NN;
      
      
   end Neuro_Process;

end El.Neural ; 
