-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Params ; 
with El.Option ;
with El.Termin ;

package El.Interf is
   type Interf_Record is new Termin.Termin_Record with
      record
	 Parameters_Kit : Params.Parameters_Kit_Record_Type;
	 Options_Kit    : Option.Options_Kit_Array_Type;	 
      end record;
   
   use Params;   

   procedure Initialize (Int : in out Interf_Record);
   
   procedure Parameters_Descriptions
     (From : in Interf_Record);
   procedure Print_Parameters (Interf : in Interf_Record'class);
   function Get_Parameter
     (From : in Interf_Record;
      Flag : in Parameters_Flags_Enum_Type)
     return Parameter_Tagged_Record_Type;      
   
   
   function Get_Lines (Int : in Interf_Record) return Positive;
   function Get_Cols (Int : in Interf_Record) return Positive;
   
   function Columns_Number (Line : in Wide_String) return Positive;
   function Lines_Number (Line : in Wide_String) return Positive;
private
   
   function Set_Parameters_From (Filename : in Wide_String)      
				return access Parameters_Kit_Record_Type;

end El.Interf ; 
