-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Cyborg ;
with El.Search ;
with El.Classe ;
with El.Window ;
with El.Aiinfo ;
with El.Axiome ;
------------------------------------------------------
--
--
with El.Classe.Universe_class;
with El.Classe.Notes_class;
with El.Classe.Contacts_class;
with El.Classe.Events_class;
with El.Classe.Animals_class;
with El.Classe.Accounting;
with El.Classe.Account_Lines_class;
with El.Classe.Cars_class;
with El.Classe.Houses_class;
with El.Classe.Contents_class;
with El.Classe.Activities_class;
with El.Classe.deallines_class;
with El.Classe.Planning_class;
with El.Classe.Plans_class;
with El.Classe.Accoun ;
with El.Classe.Define ;
--
--
with Ada.Containers.Vectors;
use Ada.Containers;
with Ada.Calendar.Formatting;
use Ada.Calendar;
with Ada.Unchecked_Deallocation;
use Ada;

------------------------------------------------------
generic
   Glossary_Filename : String;
   Width_Line :Word_Range;
   Max_Words : Lexical_Range;
   Samples_Max : Positive;
   Network_Filename : String;
   Lines : Line_Range;
   Cols  : Column_Range;
   with package Classes is new el.Classe (<>);
   with package Window is new El.Window (<>);

package El.Intell is
   
   
   package Account is new Classes.Accoun;
   package Deallines is new Classes.Deallines_Class(Account);
   package Accountings is new Classes.Accounting;   
   package Universes is new Classes.Universe_class;
   package Notes is new Classes.Notes_Class(Cols);
   package Events is new Classes.Events_class;
   package Contacts is new Classes.Contacts_class;
   package Animals is new Classes.Animals_class;
   package Account_lines is new Classes.Account_Lines_Class(Account);
   package cars is new Classes.cars_class;
   package Houses is new Classes.Houses_class;
   package Contents is new Classes.Contents_class;
   package Activities is new Classes.Activities_class;
   package Plannings is new Classes.Planning_class;
   package Plans is new Classes.Plans_class;
   package Define is new Classes.Define;
   
   use Classes;
   use Account;
   
   use Accountings;   
   use Universes;
   use Notes;
   use Events;
   use Contacts;
   use Animals;
   use Account_Lines;
   use Cars;
   use Houses;
   use Contents;
   use Activities;
   use Deallines;
   use Plannings;
   use Plans;
   use Define;
   use Aiinfo ;
   use Axiome ;
   use Axiome.Main_Work;
   type Object_Info_Record is new Class_Info_Record with
      record
	 Name : Name_Type := (others => Wide_Character ' Val (32));
	 Old  : Duration := 0.0;
	 X    : Vector_Type := 0.0;
	 Y    : Vector_Type := 0.0;
	 Z    : Vector_Type := 0.0;
      end record;
   
   
   type Object_Info_Access is access Object_Info_Record;
   
   type Object_Array is array (Positive range <>) of Object_Info_Access;
   
   type Object_Set(Object_Max : Positive) is
      record
	 Set : Object_Array(1..Object_Max);
	 Object_Last : Natural := 0;
      end record;
   
   type Ai_Domain_Record(Max_Object : Positive) is new Aiinfo_Record with
      record
	 Objects : Object_Set(Max_Object);
	 Proof   : Preuve_Record;
	 
      end record;
   
   
   subtype Expression_Type is Wide_String(1..(Cols-2)-2-Name_Length-2);
   
   V_Win_Max   : constant Positive := ((Lines-31)/2-1)-2;
   
   
   
   subtype V_Line_Range is Positive range 1..V_Win_Max;
   
   subtype V_Index_Type is Natural range 0..(V_Win_Max * 16) - 1;      
   
   
   package Expr_Vectors is new Vectors(V_Index_Type, Expression_Type, "=");
   
   package Prompt_Vectors is new Vectors(V_Index_Type, Name_Type, "=");
   
   
      
   
   use Classes;
   use Classes.Abstracted_Vectors;
   
   type Cmd_Name is (Null_Item, Create, Help, list, Switch, Root, Print, Search, Attribute, Dump, Word);
   
   Cmd_Error : exception;
   Is_Word   : exception;
   
   function Class_Value(Line : in Wide_String) return Tag_Name;
   function Cmd_Value(Line : in Wide_String) return Cmd_Name;
   function Id (Name : in Tag_Name) return Abstracted_Access;
   function Num_Value(Line : in Wide_String) return Abstracted_Index;
   
   package Cyborg is new El.Cyborg (Glossary_Filename, Width_Line, Max_Words, Samples_Max, Network_Filename);
   
   type Intell_Record is new Cyborg.Cyborg_Record with 
     
      record
	 Classes_Ranking : access Rank_Array := new Rank_Array(1 .. 17);
      end record;
	 

end El.Intell ; 
