-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"

with El.Buffer ; 
with M.Windows ; 
with El.Enumes ;
with M ;
with Ansi_Console;
generic
   with package Window is new M.Windows (<>);
package El.Frames is
   use Window ;
   use Enumes ;
   use M ;
   use Ansi_Console;
   type Frame_Enum is (
		       -- Dailog mode 
		       Header, Global_View, Input, Resp, 
		       Output, Dialog_View, Buffer, Right_View
		      );
   
   type Frame_Record is tagged
      record
	 Style : Style_Enum := Color_And_Color;
	 Color : Color_Type := White;
	 L   : Line_Range := 1;
	 C   : Column_Range := 1;
	 H   : Line_Range := 67;
	 W   : Column_Range := 240;
	 Win : Window_record;
      end record;
      
   
   type Frame_Set is array (Frame_Enum'range) of Frame_Record;

end El.Frames ; 
