-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
generic
package El.Classe.Accounting is
   
   function Account_name(Line : in Wide_String) return Wide_String;
   
   
   type Saving_Account_Range is delta 0.01 digits 7 range 0.0..22_950.0;
   type Personal_Account_Range is delta 0.01 digits 8 range -200.0..125_000.0;
   type Enteprise_Account_Range is delta 0.01 digits 11 range -200.0..125_000_000.0;
   
   type Saving_Account_Class is new Abstracted_Class(Saved_Ac) with
      record
	 Min : Saving_Account_Range := 10.0;
	 Max : Saving_Account_Range := Saving_Account_Range'Last;	 
	 Annuity_Min : Saving_Account_Range := 90.0;
	 Factor      : Float := 0.75;
      end record;
      
   type Personal_Account_Class is new Abstracted_Class(Perso_Ac) with
      record
	 Min : Personal_Account_Range := Personal_Account_Range'First;
	 Max : Personal_Account_Range := Personal_Account_Range'Last;
	 Discovered : Personal_Account_Range := -200.0;
      end record;
   
   
   type Enteprise_Account_Class is new Abstracted_Class(Entep_Ac) with
      record
	 Min : Enteprise_Account_Range := Enteprise_Account_Range'First;
	 Max : Enteprise_Account_Range := Enteprise_Account_Range'Last;
	 Discovered : Enteprise_Account_Range := -200.0;
      end record;
   
         
   
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Min : Saving_Account_Range := 10.0;
		   Max : Saving_Account_Range := Saving_Account_Range'Last;	 
		   Name      : in Name_Type) return Abstracted_Access;
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Min : Personal_Account_Range := Personal_Account_Range'First;
		   Max : Personal_Account_Range := Personal_Account_Range'Last;
		   Name      : in Name_Type) return Abstracted_Access;
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Min : Enteprise_Account_Range := Enteprise_Account_Range'First;
		   Max : Enteprise_Account_Range := Enteprise_Account_Range'Last;
		   Name      : in Name_Type) return Abstracted_Access;
   
   
   procedure Print (Object    : in Saving_Account_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   
   procedure Print (Object    : in Personal_Account_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Print (Object    : in Enteprise_Account_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   
   procedure Help(Account    : in out Saving_Account_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   
   procedure Help(Account    : in out Personal_Account_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   procedure Help(Account    : in out Enteprise_Account_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   procedure Write (O : in Saving_Account_Class;File : in W_Io.File_Type);
   procedure Read (O : in out Saving_Account_Class;File : in W_Io.File_Type);
   procedure Random (O : in out Saving_Account_Class);
   procedure Write (O : in Personal_Account_Class;File : in W_Io.File_Type);
   procedure Read (O : in out Personal_Account_Class;File : in W_Io.File_Type);
   procedure Random (O : in out Personal_Account_Class);
   procedure Write (O : in Enteprise_Account_Class;File : in W_Io.File_Type);
   procedure Read (O : in out Enteprise_Account_Class;File : in W_Io.File_Type);
   procedure Random (O : in out Enteprise_Account_Class);


end El.Classe.Accounting ; 
