-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;

package body El.Classe.Account_lines_class is
   
   
   function sum_Value(Line : in Wide_String) return Fixed_Sum is
      Sum   : Fixed_Sum := 0.0;
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last), " ", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Last_2-1), " ", backward); 
      
   begin
      if Last_2 /= 0 then
	 Sum := Fixed_Sum'Value(To_String(Line(Last+1..Last_2-1)));
      end if;      
      return sum;
   exception
      when others =>
	 return sum;
   end sum_Value;
   
   
   function Delays_Value(Line : in Wide_String) return Days_delay is
      delays : Days_delay := 0;
      
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last), " ", backward); 
      
      
   begin
      if Last_2 /= 0 then
	 Delays := Days_Delay'Value(To_String(Line(Last_2+1..Line'last)));
      end if;      
      return delays;
   exception
      when others =>
	 return delays;
   end Delays_Value;
   
   
   function Line_Name_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      if Last /= 0 then
	 Wide_Fixed.Move(Line(next+1..Last-1), Name);
      end if;      
      return Name;
   exception
      when others =>
	 return Name;
   end Line_Name_Value;
   
   
   
   function Designation_Value(Line : in Wide_String) return Designation_Line is
      Design : Designation_Line := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
   begin
      if Next /= 0 then
	 Wide_Fixed.Move(Line(Last+1..Last_2-1), design);
      end if;      
      return design;
   exception
      when others =>
	 return design;
   end designation_Value;
   
   --------------------------------------------------------------------------
   --                        Account_Lines
   
   procedure Print (Object    : in Acc_Line_Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type) is
   begin
      Wide_Fixed.Move(Object.Name, Name, Error, Left, ' ');
      Draw(Win, Win_Index+1, 3, Cyan, "Index   : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      Draw(Win, Win_Index+2, 3, Cyan, "Created : " &
	     To_Wide_String(Image(Object.Create_Date)));
      Draw(Win, Win_Index+3, 3, Cyan, "Name    : " & Object.Name);
      Draw(Win, Win_Index+4, 3, Cyan, "Design  : ");
      Draw(Win, Win_Index+4, 14, Cyan, object.Design);
      Draw(Win, Win_Index+5, 3, Cyan, "Sum     : " & To_Wide_String(Fixed_Sum'Image(Object.Sum)));
      Draw(Win, Win_Index+6, 3, Cyan, "Date op : " & To_Wide_String(Image(Object.Date_Opp)));
      Draw(Win, Win_Index+7, 3, Cyan, "Date va : " & To_Wide_String(Image(Object.Date_Val)));
      
      Win_Index := Win_Index + 8;
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
   end Print;
   
   procedure Help(Acc_line   : in out Acc_Line_Class'class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create acc line : help");
      Draw(Win, Win_Index+2, 3, Cyan, "create Acc_Line NAME Design Sum Delays");
      
      
      Win_Index := Win_Index + 2;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');      
   end Help;
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;		   
		   Name      : in Name_Type;
		   Design    : in Designation_Line;
		   Sum       : in Fixed_Sum;
		   Delays     : in Days_Delay) return Abstracted_Access is
      
      O : Abstracted_Access := new Acc_Line_Class;
      
      Tag : Name_Type;
      
   begin
      if O /= null then
	 Acc_Line_Class(O.all).Design := Design;
	 Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	 Wide_Fixed.Move(Design, Acc_Line_Class(O.all).Design, Error, Left, ' ');
	 Acc_Line_Class(O.all).Sum := Sum;
	 Acc_Line_Class(O.all).Date_Val :=
	   Acc_Line_Class(O.all).Date_opp + (Delays * 86400.0);
	 
	 Acc_Line_Class(O.all).Print(Win, Win_Index, Tag);
	 --  Draw(Win, Win_Index+1, 3, Cyan, "Created : " &
	 --  	To_Wide_String(Image(Acc_Line_Class(O.all).Create_Date)));
	 --  Draw(Win, Win_Index+2, 3, Cyan, "Name    : " &
	 --  	Acc_Line_Class(O.all).Name);
	 --  Draw(Win, Win_Index+3, 3, Cyan, "Design  : " &
	 --  	Acc_Line_Class(O.all).Design);
	 --  Draw(Win, Win_Index+4, 3, Cyan, "Date op : " &
	 --  	To_Wide_String(Image(Acc_Line_Class(O.all).Date_Opp)));
	 --  Draw(Win, Win_Index+5, 3, Cyan, "Date va : " &
	 --  	To_Wide_String(Image(Acc_Line_Class(O.all).Date_val)));
	 
	 Win_Index := Win_Index + 6;
	 return O;
      else
	 return null;
      end if;
   end Create;
   
   procedure Write (O : in Acc_Line_Class; File : in W_Io.File_Type) is
   begin            
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, Wide_String(O.Design));
      W_Io.Put_Line(File, To_Wide_String(Fixed_Sum'Image(O.Sum)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Date_opp)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Date_val)));
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
   procedure Read (O : in out Acc_Line_Class; File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      Design_Last : Natural := 0;
      Empty : Wide_String(1..80);
      Empty_Last : Natural := 0;
      
      Att_Index : Natural := 0;
   begin           
      W_Io.Get_Line(File, Empty, Empty_Last); 
      -- obscure blank line      
      
      
      
      O.Index := Integer'Value(To_String(W_Io.Get_Line(File)));
      
      
      
      O.Create_Date := Value(To_String(W_Io.Get_Line(File)));
      
      
      
      
      W_Io.Get_Line(File, O.Name, Name_last);
      
      
      
      
      W_Io.Get_Line(File, Empty, Empty_Last); 
      -- obscure blank line      
      
      W_Io.Get_Line(File, O.Design, Design_Last);
      
      
      
      W_Io.Get_Line(File, Empty, Empty_Last); 
      -- obscure blank line      
      
      W_Io.Get_Line(File, Empty, Empty_Last); 
      
      
      
      O.Sum := Fixed_sum'Value(To_String(Empty(Empty'First..Empty_Last)));
      
      
      
      
      
      
      
      
      O.Date_opp := Value(To_String(W_Io.Get_Line(File)));
      
      
      O.Date_val := Value(To_String(W_Io.Get_Line(File)));
      
      
      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;

      
   end Read;
   
   
   procedure Random (O : in out Acc_Line_Class) is
   begin
      null;
   end Random;

end El.Classe.Account_lines_class ; 
