with Ada.Wide_Text_Io;
use Ada.Wide_Text_Io;
with Gnat.Sockets;
use Gnat.Sockets;

with Gnat.Cgi;
use Gnat.Cgi;
with Gnat.Cgi.Cookie;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
with Ada.Strings.Utf_Encoding.Strings;
use Ada.Strings.Utf_Encoding.Strings;


with Gnat.Directory_operations;
use Gnat.Directory_operations;
with Gnat.Directory_Operations.Iteration;
use Gnat.Directory_Operations.Iteration;
with gnat.os_lib;
use Gnat;
with Gnat.Sha1;
use Gnat.Sha1;

with Sai;
use Sai;
procedure SaiWeb is
   
   

   
   package Wfixed renames Wide_Fixed;
   
   
   type Wide_String_Access is access all Wide_String;
   
   type Arg_Entry is
      record	 
	 Value   : Wide_String_Access;
	 Is_Set  : Boolean := False;
      end record;
   
   type Arg_array is array (Id_Range) of Arg_Entry;
   
   
   Add  : Gnat.sockets.Sock_Addr_Type;
   Socket   : Socket_Type;
   Channel  : Gnat.sockets.Stream_Access;
   Logged   : Boolean := False;
   Available : Boolean := False;
   Product   : Boolean := False;
   
   
   Enregistrement : Enregistrement_Record;
   Index          : Natural := 0;
   Command        : Command_Record;
   Facture        : Facture_Record;
   Card           : Bank_Info_Type;
   
   Arg_Table : Arg_Array;
   No_Problem : Boolean := True;
   File : File_Type;
   Name_Done : Boolean := False;
   email_Done : Boolean := False;
   Address_Done : Boolean := False;
   Phone_Done : Boolean := False;
   Id_Transaction : Natural := 0;
   Bank_Info      : Bank_Info_Type := Null_Card;
   Hello : Os_Lib.String_Access;
begin           
   if not Ok then
      raise Program_Error;
   end if;
   
   Put_Header(Default_Header);	 
   Put_Line("<!Doctype html>");
   Put_Line("<html>");
	 
   
   if Argument_Count = 1 and then Key_Exists("Id_Transaction") then		
      Add.Addr :=
	Gnat.Sockets.Addresses (Gnat.Sockets.Get_Host_By_Name ("localhost"), 1);
      
      Add.Port := 1970;
      Gnat.sockets.Create_Socket (Socket);
      delay 0.1;
      Gnat.Sockets.Set_Socket_Option
	(Socket,
	 Gnat.Sockets.Socket_Level,
	 (Gnat.Sockets.Reuse_Address, True));      
      delay 0.1;      
      Gnat.sockets.Connect_Socket (Socket, Add);
      delay 0.1;
      Channel := Gnat.sockets.Stream (Socket);
      String'Output (Channel, "webi");
      Sha1.Message_Digest'Output (Channel, Sha1.Digest("webi"));
      Logged := Boolean'Input(Channel);	 
      if Logged then
	 
	 Command_Enum'Output(Channel, Paiement);
	 Id_Transaction := Natural'Value(Value("Id_Transaction"));
	 Natural'Output(Channel, Id_Transaction);
	 
	 Wfixed.Move(To_Wide_String(Decode(Value("Name"))), Bank_Info.Name);
	 Wfixed.Move(To_Wide_String(Value("Card_Num")), Bank_Info.Card_Num);
	 Wfixed.Move(To_Wide_String(Value("Exp_Date")), Bank_Info.Exp);
	 Wfixed.Move(To_Wide_String(Value("Sign")), Bank_Info.sign);
	 
	 
	 Put_Line("<head>");
	 Put_Line("<meta charset=""UTF-8"">");
	 Put_Line("<title>Validation</title>");
	 Put_Line("</head>");
	 Put_Line("<body background=""/images/spectre.jpg"">");
         Put_Line("<table align=""center"" width=""66%"">");
   	 Put_Line("<tr><td>");
         Put_Line("<table align=""left"" width=""100%"">");
         Put_Line("<tr><td>");

	 Put_Line("<h2>Validation</h2>");
	 Put_Line("Votre paiement est accepté.");
	 Put_Line("Voici votre facture afin de faire valoir vos droits.");
	 Put_Line("<h3>Programmes(s) commandé(s)</h3>");
	 
	 Index := Natural'Input(Channel);
	 for I in 1..Index loop
	    declare
	       Product : Product_Enum := Product_Enum'Input(Channel);
	       Price   : Price_Type := 0.0;
	    begin
	       if Product = Null_Item then
	 	  Price := Price_Type'Input(Channel);
	 	  Command.Products(Product) := Price;
		  if Command.Products(Product) /= 0.0 then
		     Put_Line("Product : " & To_Wide_String(Product_Enum'Image(Product)) & " := " & To_Wide_String(Price_Type'Image(Command.Products(Product))) & " € ; <br>");
		  end if;
	       end if;
	    end;
	 end loop;
	 Command.HT_Sum := Price_Type'Input(Channel);
	 Command.TVA := Price_Type'Input(Channel);
	 Command.TTC_Sum := Price_Type'Input(Channel);
	 Put_line("Facture N° " & To_Wide_String(Natural'Image(Id_Transaction)) & "<br>");
	 
	 Put_Line("Selon le taux de taxe sur la valeur ajouté, à  20% <br>");
	 
	 Put_Line("Total HT  : " & To_Wide_String(Price_Type'Image(Command.HT_Sum)) & " € ; <br>");
	 Put_Line("Total TVA : " & To_Wide_String(Price_Type'Image(Command.TVA)) & " € ; <br>");
	 Put_Line("Total TTC : " & To_Wide_String(Price_Type'Image(Command.TTC_Sum)) & " €.");
	 Put_Line("</td></tr></table></td></tr></table>");
	 Put_Line("<a href=""/cgi-bin/webmain"">Retour</a>");
	 Put_Line("</body>");
	 Put_Line("</html>");
	 
	 
      end if;
   elsif Argument_Count > 1 and Key_Exists("Id_Transaction") then
      
      for I in Id_Range loop
	 begin
	    Arg_Table(I).Value := new Wide_String ' (To_Wide_String(Decode(Value(To_Lower(Id_Range'Image(I))))));
	    
	    if Arg_Table(I).Value'Length /= 0 then	    

	       Arg_Table(I).Is_Set := True;
	       Available := True;

	    end if;		  
	 end;
      end loop;
      for I in Product_enum'First..Null_Item loop
	 if Arg_Table(i).Is_Set then

	    Product := True;
	 end if;
      end loop;
      
      
      
      if Arg_Table(name).Is_Set then
	 Name_Done := True;
      end if;
      if Arg_Table(email).Is_Set then
	 Email_Done := True;
      end if;   
      if Arg_Table(address).Is_Set then
	 Address_Done := True;
      end if;
      if Arg_Table(phone).Is_Set then
	 Phone_Done := True;
      end if;      
      if available then	
	 if not Name_Done then
	    
	    Put_Line("<head>");
	    Put_Line("<meta charset=""UTF-8"">");
	    Put_Line("<title>Nom ?</title>");
	    Put_Line("</head>");
	    Put_Line("<body background=""/images/spectre.jpg"">");
	    Put_Line("indiquer votre nom.");
	    Put_Line("</body>");
	    Put_Line("</html>");
	 else
	    if not (Phone_Done and Email_Done and Address_Done) then
	       
	       Put_Line("<head>");
	       Put_Line("<meta charset=""UTF-8"">");
	       Put_Line("<title>Contact ?</title>");
	       Put_Line("</head>");
	       Put_Line("<body background=""/images/spectre.jpg"">");
	       Put_Line("indiquer votre contact.");
	       Put_Line("</body>");
	       Put_Line("</html>");
	    else
	       Put_Header(Default_Header);
	       

	       
	       
	       Put_Line("<head>");
	       Put_Line("<meta charset=""UTF-8"">");
	       Put_Line("<title>Récapitulatif</title>");
	       Put_Line("</head>");
	       Put_Line("<body background=""/images/spectre.jpg"">");
	       Put_Line("<h2>Vérification</h2>");
	       ------------------------------------------------------
	       --                                                  --
	       --                                                  --
	       ------------------------------------------------------
	       Put_Line("<table align=""center"" width=""66%"">");
	       Put_Line("<tr><td>");
               Put_Line("<table align=""left"" width=""100%"">");
               Put_Line("<tr><td>");
	       if Product then
		  --if Arg_Table(Compta).Is_set or Arg_Table(Devel).Is_set or Arg_Table(Chessgame).Is_set or Arg_Table(Dialog).Is_set or Arg_Table(Manager).Is_set then
		  No_Problem := False;
		  
		  if not Address_Done then
		     Put_Line("<h2>Addresse de résidence requise</h2>");
		     Put_Line("<B>Vous</B> devez indiquer votre adresse de résidence afin que nous vous fassions parvenir les programmes commandés.");
		     --  else		  
		     --  	  for I in Compta..Manager loop
		     --  	     if Arg_Table(I).Is_Set then
		     --  		Put_Line(Arg_Table(I).Value.all & "<br>");
		     --  	     end if;
		     --  	  end loop;		  
		  end if;	       
	       end if;

	       if Arg_Table(Objectif).Is_Set or Arg_Table(Motivations).Is_Set or Arg_Table(Objet).Is_Set or Arg_Table(Arguments).Is_Set then	       
		  No_Problem := False;
		  if not (Arg_Table(Objectif).Is_Set and Arg_Table(Motivations).Is_Set and Arg_Table(Objet).Is_Set and Arg_Table(Arguments).Is_Set) then
		     Put_Line("<h2>Commande de logiciel incomplète</h2>");
		     Put_Line("Pour une commande de logiciel <B>vous</B> devez remplir chacun des champs prévu à cet effet.");		 		  
		  else
		     
		     if not Email_Done then
			Put_Line("<h2>Commande de logiciel</h2>");
			Put_Line("Pour une commande de logicial <B>vous</B> devez nous communiquer votre adresse email.");		 
		     elsif not Address_done then
			Put_Line("<h2>Commande de logiciel</h2>");
			Put_Line("Pour une commande de logicial <B>vous</B> devez nous communiquer votre adresse de résidence."); 
			--  else
			
			--  for I in objectif..Arguments loop
			--  	if Arg_Table(I).Is_Set then
			--  	   Put_Line(Arg_Table(I).Value.all & "<br>");
			--  	end if;
			--  end loop;
		     else
			
			if (Arg_Table(Objectif).Is_Set and Arg_Table(Motivations).Is_Set and Arg_Table(Objet).Is_Set and Arg_Table(Arguments).Is_Set) then		       
			   -- Prise en charge du projet logiciel
			   Put_Line("<h2>Prise en charge de votre dossier logiciel</h2>");
			   Put_Line("<h3>Objectif</h3>"); 
			   Put_Line("Le résultat attendu : " & Arg_Table(objectif).Value.all); 
			   Put_Line("<h3>Motivations</h3>"); 
			   Put_Line("Les avantages du dit logiciel : " & Arg_Table(Motivations).Value.all); 
			   Put_Line("<h3>Objet</h3>"); 
			   Put_Line("Le but du logiciel : " & Arg_Table(objet).Value.all); 
			   Put_Line("<h3>Arguments</h3>"); 
			   Put_Line("Le context d'utilisation : " & Arg_Table(Arguments).Value.all); 
			end if;		  
		     end if;	       
		  end if;
	       end if;


	       Wfixed.Move(Arg_Table(Name).Value.all, Enregistrement.Coordonates.Name);

	       fixed.Move(To_String(Arg_Table(email).Value.all), Enregistrement.Coordonates.email);

	       Wfixed.Move(Arg_Table(address).Value.all, Enregistrement.Coordonates.address);

	       fixed.Move(To_String(Arg_Table(Phone).Value.all), Enregistrement.Coordonates.phone);

	       for I in Product_enum'First..Null_Item loop		  
		  fixed.Move(To_String(Arg_Table(I).Value.all), Enregistrement.Programs(Product_enum'Pos(I)+1));
	       end loop;


	       Wfixed.Move(Arg_Table(Objectif).Value.all, Enregistrement.Logicial.Objectif);
	       Wfixed.Move(Arg_Table(Motivations).Value.all, Enregistrement.Logicial.Motivations);
	       Wfixed.Move(Arg_Table(Objet).Value.all, Enregistrement.Logicial.Objet);
	       Wfixed.Move(Arg_Table(Arguments).Value.all, Enregistrement.Logicial.arguments);

      
	       begin
		  Wide_Fixed.Move(To_Wide_String(Decode(Value("program_name"))), Enregistrement.Solution.Name);
		  Wide_Fixed.Move(To_Wide_String(Decode(Value("axiomatique"))), Enregistrement.Solution.axiomatic);
		  Enregistrement.Solution.Formule := Solution_Enum'Value(Value("formule"));
		  case Enregistrement.Solution.Formule is
		     when Carte =>
			for I in 1..Argument_Count loop
			   begin

			      Enregistrement.Solution.Forfaits(Forfait_Enum'Value(Key(i))) := True;

			   exception
			      when others =>
				 null;
			   end;		  
			   
			end loop;
		     when others =>
			null;
		  end case;

		  Enregistrement.Solution.Method := Method_Enum'Value(Decode(Value("method")));
		  

		  

		  for I in 1..Argument_Count loop
		     begin
			Enregistrement.Solution.Contexts(Context_Enum'Value(Key(i))) := True;	       
		     exception
			when others =>
			   null;
		     end;
		  end loop;
		  

		  
		  Enregistrement.Solution.Process := Process_Enum'Value(Decode(Value("maquetage")));
		  for I in 1..Argument_Count loop
		     begin
			Enregistrement.Solution.ints(Int_Enum'Value(Key(i))) := True;
		     exception
			when others =>
			   null;
		     end;
		  end loop;	 
	       end;

      
	       Add.Addr :=
		 Gnat.Sockets.Addresses (Gnat.Sockets.Get_Host_By_Name ("localhost"), 1);
	       
	       Add.Port := 1970;
	       Gnat.sockets.Create_Socket (Socket);
	       delay 0.1;
	       Gnat.Sockets.Set_Socket_Option
		 (Socket,
		  Gnat.Sockets.Socket_Level,
		  (Gnat.Sockets.Reuse_Address, True));      
	       delay 0.1;      
	       Gnat.sockets.Connect_Socket (Socket, Add);
	       delay 0.1;
	       Channel := Gnat.sockets.Stream (Socket);
	       String'Output (Channel, "webi");
	       Sha1.Message_Digest'Output (Channel, Sha1.Digest("webi"));
	       Logged := Boolean'Input(Channel);	 
	       if Logged then
		  Command_Enum'Output(Channel, validation);
		  Id_Transaction := Natural'Value(Value("Id_Transaction"));
		  Enregistrement_Record'Output(Channel, Enregistrement);
		  Enregistrement := Enregistrement_Record'Input(Channel);
		  Natural'Output(Channel, Id_Transaction);
		  Wide_String'Output(Channel, Enregistrement.Coordonates.name);
		  String'Output(Channel, Enregistrement.Coordonates.email);
		  Wide_String'Output(Channel, Enregistrement.Coordonates.address);
		  
		  String'Output(Channel, Enregistrement.Coordonates.phone);
		  String'Output(Channel, Enregistrement.Programs(1));
		  String'Output(Channel, Enregistrement.Programs(2));
		  String'Output(Channel, Enregistrement.Programs(3));
		  String'Output(Channel, Enregistrement.Programs(4));
		  String'Output(Channel, Enregistrement.Programs(5));
		  String'Output(Channel, Enregistrement.Programs(6));
		  String'Output(Channel, Enregistrement.Programs(7));
		  String'Output(Channel, Enregistrement.Programs(8));
		  String'Output(Channel, Enregistrement.Programs(9));
		  String'Output(Channel, Enregistrement.Programs(10));
		  
		  Wide_String'Output(Channel, Enregistrement.Logicial.objectif);
		  
		  Wide_String'Output(Channel, Enregistrement.Logicial.motivations);
		  
		  Wide_String'Output(Channel, Enregistrement.Logicial.objet);
		  
		  Wide_String'Output(Channel, Enregistrement.Logicial.arguments);
		  
		  Put_Line("<h2>Production de logiciel</h2>");
		  Put_Line("<h3>Propriétés</h3>");
		  Put_Line("<h4>Nom de programme</h4>");
		  Put_Line(Enregistrement.Solution.Name);
		  Put_Line("<h4>Axiomatique</h4>");
		  Put_Line(Enregistrement.Solution.Axiomatic);
		  Put_Line("<h3>Modèle de solution</h3>");
		  if Enregistrement.Solution.formule = Carte then
		     Put_Line("<h4>Carte</h4>");
		     Put_Line("<ul>");
		     for Forfait in Forfait_Enum'Range loop
			if Enregistrement.Solution.Forfaits(Forfait) then
			   Put_Line("<li>" & To_Wide_String(Forfait_Enum'Image(Forfait)));
			end if;
		     end loop;
		     Put_Line("</ul>");
		  else
		     Put_Line("<h4>Formule</h4>");
		     Put_Line(To_Wide_String(Solution_Enum'Image(Enregistrement.Solution.Formule)));
		  end if;
		  Put_Line("<h4>Méthode</h4>");
		  
		  Put_Line(To_Wide_String(Method_Enum'Image(Enregistrement.Solution.Method)));
		  Put_Line("<h4>Contexts</h4>");
		  Put_Line("<ul>");
		  for Context in Context_Enum'Range loop
		     if Enregistrement.Solution.Contexts(Context) then
			Put_Line("<li>" & To_Wide_String(Context_Enum'Image(Context)));
		     end if;
		  end loop;
		  Put_Line("</ul>");
		  Put_Line("<h4>Elaboration</h4>");
		  Put_Line(To_Wide_String(Process_Enum'Image(Enregistrement.Solution.Process)));
		  
		  Put_Line("<h4>Interfaces</h4>");
		  Put_Line("<ul>");
		  for Int in Int_Enum'Range loop
		     if Enregistrement.Solution.Ints(Int) then
			Put_Line("<li>" & To_Wide_String(Int_Enum'Image(int)));
		     end if;
		  end loop;
		  Put_Line("</ul>");
		  delay 5.0;
		  if Cookie.Count = 1 and then Cookie.Value(Key => "logname")'Length > 0 then
		     
		     Put_Line("  <table align=""center"" width=""100%"">");
		     Put_Line(""); 
		     Put_Line("    <tr><td>");
		     Put_Line("<form action=""/cgi-bin/procgi"" method=""post"">");
		     Put_Line("   <table border=""1"">");
		     Put_Line("   <tr><td>Name</td><td>Path</td><td>Delete</td></tr>");
		     
		     declare
			
			procedure Table_Action
			  (Item  :        String;
			   Index :        Positive;
			   Quit  : in out Boolean) is
			begin
			   if Base_Name(Item) /= Value("logname") then
			      if Os_Lib.Is_Directory(Item) then
				 Put_Line("   <tr><td>" & To_Wide_String(Base_Name(Item)) & "</td><td><a href=""/" & To_Wide_String(CGI.Cookie.Value("logname")) & '/' & To_Wide_String(Base_Name(Item)) & '/' & To_Wide_String(Base_Name(Item)) & ".tgz"">" & 
						 To_Wide_String(Base_Name(Item)) & ".tgz</a></td><td><input type=""checkbox"" value=""" & To_Wide_String(Base_Name(Item)) & """ id=""" & 
						 To_Wide_String(Base_Name(Item)) & """ name=""" & To_Wide_String(Base_Name(Item)) & """></td></tr>   ");
			      end if;
			   end if;
			end Table_Action;
			
			procedure Iterator is new Wildcard_Iterator (Table_Action);
		     begin
			Iterator("/var/www/html/" & CGI.Cookie.Value("logname") & "/*");
		     end;

		     
		     
		     Put_Line("   </table>");
		     Put_Line("   <input type=""reset"" value=""Reset""><input type=""submit"" value=""Submit"">");
		     Put_Line("   </form>");
		     Put_Line("");   
		     Put_Line("    </td></tr>");
		     Put_Line(" </table>");
	 
		  end if;
		  -- Aquisition de Programmes :
		  Put_Line("<h2>Programmes(s) commandé(s)</h2>");
		  
		  Index := Natural'Input(Channel);

		  
		  for I in 1..Index loop
		     declare
			Product : Product_Enum := Product_Enum'Input(Channel);
			Price   : Price_Type := 0.0;
		     begin


			   Price := Price_Type'Input(Channel);

			   Command.Products(Product) := Price;

		     exception
			when others =>
			   null;
		     end;
		  end loop;
		  
		  Command.HT_Sum := Price_Type'Input(Channel);
		  Command.TVA := Price_Type'Input(Channel);
		  Command.TTC_Sum := Price_Type'Input(Channel);

		  Id_Transaction := Natural'Input(Channel);
		  
		  Put_Line("Selon le taux de taxe sur la valeur ajouté, voici nos prix : <br>");
		  for Product in Product_enum loop
		     if Command.Products(Product) /= 0.0 then
			Put_Line("Product : " & To_Wide_String(Product_Enum'Image(Product)) & " := " & To_Wide_String(Price_Type'Image(Command.Products(Product))) & " € ; <br>");
		     end if;
		  end loop;
		  Put_Line("Total HT  : " & To_Wide_String(Price_Type'Image(Command.HT_Sum)) & " € ; <br>");
		  Put_Line("Total TVA : " & To_Wide_String(Price_Type'Image(Command.TVA)) & " € ; <br>");
		  Put_Line("Total TTC : " & To_Wide_String(Price_Type'Image(Command.TTC_Sum)) & " €.");
		  Put_Line("<br>");
		  Put_Line("Votre demande sera traité dans un delay de 48 à 72 heures");
		  Put_Line("<br>");		  
		  Put_Line("Merci de votre compréhension !");	       
		  Put_Line("<br>");

		  ----------------------------------------------------------------------
		  -- Paiement form :
		  -----------------------------------------------------------------------
		  Put_Line("<form action=""/cgi-bin/saiweb"" method=""Post"">");
		  --  Put_Line("Name : <Input type=""Textarea"" cols=""32"" name=""Name"" id=""Name"" /><br>");
		  --  Put_Line("Card Number : <Input type=""Textarea"" cols=""14"" name=""Card_Num"" id=""Card_Num"" /><br>");
		  --  Put_Line("Expiration date : <Input type=""Textarea"" cols=""6"" name=""Exp_Date"" id=""Exp_Date"" /><br>");
		  --  Put_Line("Code : <Input type=""Textarea"" cols=""3"" name=""Sign"" id=""Sign"" /><br>");
		  --  Put_Line("<Input type=""hidden"" name=""Id_Transaction"" id=""Id_Transaction"" value=""" & To_Wide_String(Natural'Image(Id_Transaction)(2..Natural'Image(Id_Transaction)'last))& """/>");
		  Put_Line("<input type=""submit"" name=""submit"" id=""submit"" value=""Envoyer"" /> ");      
		  Put_Line("<input type=""reset"" name=""reset"" id=""reset"" value=""Effacer"" /><br> ");
		  Put_Line("</form>");
		  Put_Line("<a href=""/cgi-bin/webi"">Retour</a>");
		  Put_Line("</body>");
		  Put_Line("</html>");      	 
	       else
		  
		  Put_Line("<head>");
		  Put_Line("<title>Server offline</title>");
		  Put_Line("</head>");
		  Put_Line("<body>");
		  Put_Line("Server offline");
		  Put_Line("<a href=""/cgi-bin/webi"">Retour</a>");
		  Put_Line("</body>");
		  Put_Line("</html>");
	       end if;
	    
	       Gnat.Sockets.Close_Socket(Socket);
	    end if;
	 end if;	 
      else
	    
	 
	 
	 if No_Problem then 
	     
	    Put_Line("<head>");
	    Put_Line("<meta charset=""UTF-8"">");
	    Put_Line("<title>Récapitulatif</title>");
	    Put_Line("</head>");
	    Put_Line("<body background=""/images/spectre.jpg"">");		    
	    Put_Line("<h2>Vérification</h2>");
	    Put_Line("Malgrès notre attention, notre formulaire reste inutilisé.<br>");
	    Put_Line("Vous pouvez retourner à l'adresse précédente.");
	    Put_Line("Pour vous acquiter de votre achat ; Merci de verser la somme totale sur le compte chèque postal de Manuel De Girardi à la Banque Postale.<br>");
	    Put_Line("<a href=""/cgi-bin/webi"">Retour</a>");
	    Put_Line("</body>");
	    Put_Line("</html>");      	 
	 end if;
      end if;
   else
      for I in Id_Range loop
	 begin
	    Arg_Table(I).Value := new Wide_String ' (To_Wide_String(Decode(Value(To_Lower(Id_Range'Image(I))))));
	    if Arg_Table(I).Value'Length /= 0 then	    

	       Arg_Table(I).Is_Set := True;
	       Available := True;

	    end if;		  
	 end;
      end loop;
      for I in Product_enum'First..Null_Item loop
	 if Arg_Table(i).Is_Set then

	    Product := True;
	 end if;
      end loop;
      
      
      
      if Arg_Table(name).Is_Set then
	 Name_Done := True;
      end if;
      if Arg_Table(email).Is_Set then
	 Email_Done := True;
      end if;   
      if Arg_Table(address).Is_Set then
	 Address_Done := True;
      end if;
      if Arg_Table(phone).Is_Set then
	 Phone_Done := True;
      end if;      
      if available then	
	 if not Name_Done then
	    
	    Put_Line("<head>");
	    Put_Line("<meta charset=""UTF-8"">");
	    Put_Line("<title>Nom ? ?</title>");
	    Put_Line("</head>");
	    Put_Line("<body background=""/images/spectre.jpg"">");
	    Put_Line("indiquer votre nom.");
	    Put_Line("</body>");
	    Put_Line("</html>");
	 else
	    if not (Phone_Done and Email_Done and Address_Done) then
	       
	       Put_Line("<head>");
	       Put_Line("<meta charset=""UTF-8"">");
	       Put_Line("<title>Contact ?</title>");
	       Put_Line("</head>");
	       Put_Line("<body background=""/images/spectre.jpg"">");
	       Put_Line("indiquer votre contact.");
	       Put_Line("</body>");
	       Put_Line("</html>");
	    else
	       Put_Header(Default_Header);
	       
	       Put_Line("<head>");
	       Put_Line("<meta charset=""UTF-8"">");
	       Put_Line("<title>Récapitulatif</title>");
	       Put_Line("</head>");
	       Put_Line("<body background=""/images/spectre.jpg"">");
	       Put_Line("<table align=""center"" width=""66%"">");
	       Put_Line("<tr><td>");
               Put_Line("<table align=""left"" width=""100%"">");
               Put_Line("<tr><td>");

	       if Product then
		  --if Arg_Table(Compta).Is_set or Arg_Table(Devel).Is_set or Arg_Table(Chessgame).Is_set or Arg_Table(Dialog).Is_set or Arg_Table(Manager).Is_set then
		  No_Problem := False;

		  if not Address_Done then
		     Put_Line("<h2>Addresse de résidence requise</h2>");
		     Put_Line("<B>Vous</B> devez indiquer votre adresse de résidence afin que nous vous fassions parvenir les programmes commandés.");
		     --  else		  
		     --  	  for I in Compta..Manager loop
		     --  	     if Arg_Table(I).Is_Set then
		     --  		Put_Line(Arg_Table(I).Value.all & "<br>");
		     --  	     end if;
		     --  	  end loop;		  
		  end if;	       
	       end if;

	       if Arg_Table(Objectif).Is_Set or Arg_Table(Motivations).Is_Set or Arg_Table(Objet).Is_Set or Arg_Table(Arguments).Is_Set then	       
		  No_Problem := False;
		  if not (Arg_Table(Objectif).Is_Set and Arg_Table(Motivations).Is_Set and Arg_Table(Objet).Is_Set and Arg_Table(Arguments).Is_Set) then
		     Put_Line("<h2>Commande de logiciel incomplète</h2>");
		     Put_Line("Pour une commande de logiciel <B>vous</B> devez remplir chacun des champs prévu à cet effet.");		 		  
		  else
		     
		     if not Email_Done then
			Put_Line("<h2>Commande de logiciel</h2>");
			Put_Line("Pour une commande de logicial <B>vous</B> devez nous communiquer votre adresse email.");		 
		     elsif not Address_done then
			Put_Line("<h2>Commande de logiciel</h2>");
			Put_Line("Pour une commande de logicial <B>vous</B> devez nous communiquer votre adresse de résidence."); 
			--  else
			
			--  for I in objectif..Arguments loop
			--  	if Arg_Table(I).Is_Set then
			--  	   Put_Line(Arg_Table(I).Value.all & "<br>");
			--  	end if;
			--  end loop;
		     end if;		  
		  end if;	       
	       end if;


	       Wfixed.Move(Arg_Table(Name).Value.all, Enregistrement.Coordonates.Name);

	       fixed.Move(To_String(Arg_Table(email).Value.all), Enregistrement.Coordonates.email);

	       Wfixed.Move(Arg_Table(address).Value.all, Enregistrement.Coordonates.address);

	       fixed.Move(To_String(Arg_Table(Phone).Value.all), Enregistrement.Coordonates.phone);

	       for I in Product_enum'First..Null_Item loop		  
		  
		  fixed.Move(To_String(Arg_Table(I).Value.all), Enregistrement.Programs(Product_enum'Pos(I)+1));
	       end loop;


	       Wfixed.Move(Arg_Table(Objectif).Value.all, Enregistrement.Logicial.Objectif);
	       Wfixed.Move(Arg_Table(Motivations).Value.all, Enregistrement.Logicial.Motivations);
	       Wfixed.Move(Arg_Table(Objet).Value.all, Enregistrement.Logicial.Objet);
	       Wfixed.Move(Arg_Table(Arguments).Value.all, Enregistrement.Logicial.arguments);

	       ---------------------------------------
	       -- Connection :
	       ---------------------------------------
	       Add.Addr :=
		 Gnat.Sockets.Addresses (Gnat.Sockets.Get_Host_By_Name ("localhost"), 1);
	       
	       Add.Port := 1970;
	       Gnat.sockets.Create_Socket (Socket);
	       delay 0.1;
	       Gnat.Sockets.Set_Socket_Option
		 (Socket,
		  Gnat.Sockets.Socket_Level,
		  (Gnat.Sockets.Reuse_Address, True));      
	       delay 0.1;      

	       Gnat.sockets.Connect_Socket (Socket, Add);
	       delay 0.1;
	       Channel := Gnat.sockets.Stream (Socket);
	       String'Output (Channel, "webi");
	       Sha1.Message_Digest'Output (Channel, Sha1.Digest("webi"));

	       Logged := Boolean'Input(Channel);	 

	       if Logged then
		  
		  Command_Enum'Output(Channel, Cmd);
		  
		  Wide_String'Output(Channel, Enregistrement.Coordonates.name);
		  String'Output(Channel, Enregistrement.Coordonates.email);
		  Wide_String'Output(Channel, Enregistrement.Coordonates.address);

		  String'Output(Channel, Enregistrement.Coordonates.phone);
		  String'Output(Channel, Enregistrement.Programs(1));
		  String'Output(Channel, Enregistrement.Programs(2));
		  String'Output(Channel, Enregistrement.Programs(3));
		  String'Output(Channel, Enregistrement.Programs(4));
		  String'Output(Channel, Enregistrement.Programs(5));
		  String'Output(Channel, Enregistrement.Programs(6));
		  String'Output(Channel, Enregistrement.Programs(7));
		  String'Output(Channel, Enregistrement.Programs(8));
		  String'Output(Channel, Enregistrement.Programs(9));
		  String'Output(Channel, Enregistrement.Programs(10));

		  Wide_String'Output(Channel, Enregistrement.Logicial.objectif);
		  
		  Wide_String'Output(Channel, Enregistrement.Logicial.motivations);

		  Wide_String'Output(Channel, Enregistrement.Logicial.objet);

		  Wide_String'Output(Channel, Enregistrement.Logicial.arguments);
		  
		  

		  		  
		  
		  
		  
		  
		  
		  
		  -- Recapitulatif --
		  Put_Line("<h1>Confirmation</h1>");	       
		  Put_Line("Nous vous demandons de compléter le formulaire suivant afin de répondre à votre commande.<br>");
		  if (Arg_Table(Objectif).Is_Set and Arg_Table(Motivations).Is_Set and Arg_Table(Objet).Is_Set and Arg_Table(Arguments).Is_Set) then		       
		     -- Prise en charge du projet logiciel
		     Put_Line("<h2>Prise en charge de votre dossier logiciel</h2>");
		     Put_Line("<h3>Objectif</h3>"); 
		     Put_Line("Le résultat attendu : " & Arg_Table(objectif).Value.all); 
		     Put_Line("<h3>Motivations</h3>"); 
		     Put_Line("Les avantages du dit logiciel : " & Arg_Table(Motivations).Value.all); 
		     Put_Line("<h3>Objet</h3>"); 
		     Put_Line("Le but du logiciel : " & Arg_Table(objet).Value.all); 
		     Put_Line("<h3>Arguments</h3>"); 
		     Put_Line("Le context d'utilisation : " & Arg_Table(Arguments).Value.all); 
		     ---------------------------------------------------------------
		     --                                                           --
		     Put_Line("<form action=""/cgi-bin/saiweb"" method=""Post"">");
		     
		     Put_Line("<input type=""hidden"" name=""name"" id=""name"" value=""" & Enregistrement.Coordonates.name & """ />");
		     Put_Line("<input type=""hidden"" name=""email"" id=""email"" value=""" & To_Wide_String(Enregistrement.Coordonates.Email) & """ />");
		     Put_Line("<input type=""hidden"" name=""address"" id=""address"" value=""" & Enregistrement.Coordonates.Address & """ />");
		     Put_Line("<input type=""hidden"" name=""phone"" id=""phone"" value=""" & To_Wide_String(Enregistrement.Coordonates.Phone) & """ />");
		     for I in Product_enum'First..Null_Item loop
			if Arg_Table(I).Is_Set then
			   Put_Line("<input type=""hidden"" name=""" & To_Wide_String(To_Lower(To_String(Arg_Table(I).Value.all))) & 
				      """ id=""" & To_Wide_String(To_Lower(To_String(Arg_Table(I).Value.all))) & """ value=""" & To_Wide_String(To_Lower(To_String(Arg_Table(I).Value.all))) & """/>");
			end if;
		     end loop;
		     
		     Put_Line("<input type=""hidden"" value=""" & Arg_Table(objectif).Value.all & """ id=""objectif"" name=""objectif"">");
		     Put_Line("<input type=""hidden"" value=""" & Arg_Table(motivations).Value.all & """ id=""motivations"" name=""motivations"">");
		     Put_Line("<input type=""hidden"" value=""" & Arg_Table(objet).Value.all & """ id=""objet"" name=""objet"">");
		     Put_Line("<input type=""hidden"" value=""" & Arg_Table(arguments).Value.all & """ id=""arguments"" name=""arguments"">");
		     Put_Line("<h2>Propriétés</h2>");
		     Put_Line("<h3>Nom de programme</h3>");
		     Put_Line("<input type=""text"" id=""program_name"" name=""program_name"" value=""""/><br>");
		     Put_Line("<h3>Axiomatique</h3>");
		     Put_Line("<textarea rows=""25"" cols=""80"" name=""axiomatique"" id=""axiomatique"" /></textarea>");
		     
		     
		     -----------------------------------------------------------------
		     --                                                             --
		     Put_Line("<h2>Cahier des Charges</h2>");
		     Put_Line("<table align=""Left"">");
		     Put_Line("<tr>");
		     Put_Line("<td>");
		     Put_Line("<h3>Modèle de solution</h3>");
		     Put_Line("<h4>Formules</h4>");
		     
		     Put_Line("Carte : <input type=""radio"" id=""formule"" name=""formule"" value=""carte"" /><br>");
		     Put_Line("Utilitaire : <input type=""radio"" id=""formule"" name=""formule"" value=""utilitaire""/><br>");
		     Put_Line("Outils : <input type=""radio"" id=""outils"" name=""formule"" value=""outils""/><br>");
		     Put_Line("Application : <input type=""radio"" id=""formule"" name=""formule"" value=""application""/><br>");
		     Put_Line("Progiciel : <input type=""radio"" id=""formule"" name=""formule"" value=""progiciel""/><br>");
		     Put_Line("Système : <input type=""radio"" id=""formule"" name=""formule"" value=""system""/>");
		     Put_Line("<h4>Carte</h4>");
		     Put_Line("<table>");
		     Put_Line("  <tr><td>Prestations</td><td>Prix hors taxes</td></tr>");
		     Put_Line("  <tr><td>Prise en charge des dossiers</td><td>16 000 €</td><td><input type=""checkbox"" id=""charge"" name=""charge"" value=""charge"" checked></td></tr>");
		     Put_Line("  <tr><td>Etude de faisabilité</td><td>32 000 €</td><td><input type=""checkbox"" id=""etude"" name=""etude"" value=""etude"" checked></td></tr>");
		     Put_Line("  <tr><td>Architecture/Ingénierie</td><td>64 000 €</td><td><input type=""checkbox"" id=""architecture"" name=""architecture"" value=""architecture""></td></tr>");
		     Put_Line("  <tr><td>Computation</td><td>16 000 € mensuel / homme / machine</td><td><input type=""checkbox"" id=""computation"" name=""computation"" value=""computation""></td></tr>");
		     Put_Line("  <tr><td>Etude de marcher</td><td>16 000 € </td><td><input type=""checkbox"" id=""marcher"" name=""marcher"" value=""marcher""></td></tr>");
		     Put_Line("  <tr><td>Enquêtes</td><td>16 000 €</td><td><input type=""checkbox"" id=""enquete"" name=""enquete"" value=""enquete""></td></tr>");
		     Put_Line("  <tr><td>Sondage</td><td>16 000 €</td><td><input type=""checkbox"" id=""sondage"" name=""sondage"" value=""sondage""></td></tr>");
		     Put_Line("  <tr><td>Site web</td><td>16 000 €</td><td><input type=""checkbox"" id=""web_site"" name=""web_site"" value=""web_site""></td></tr>");
		     Put_Line("  <tr><td>informatisation d'entreprise</td><td>64 000 €</td><td><input type=""checkbox"" id=""informatisation"" name=""informatisation"" value=""informatisation""></td></tr>");
		     Put_Line("  <tr><td>Prestations annexes</td><td>32 000 € mensuel</td><td><input type=""checkbox"" id=""prestation"" name=""prestation"" value=""prestation""></td></tr>");
		     Put_Line("</table>");
		     Put_Line("<h3>Méthodes</h3>");
		     
		     Put_Line("none :<input type=""radio"" id=""method"" name=""method"" value=""none""/>");
		     Put_Line("Genetical : <input type=""radio"" id=""method"" name=""method"" value=""genetical""/><br>");
		     Put_Line("Search : <input type=""radio"" id=""method"" name=""method"" value=""search""/><br>");
		     Put_Line("Finding : <input type=""radio"" id=""method"" name=""method"" value=""finding""/><br>");
		     Put_Line("Reenforcing : <input type=""radio"" id=""method"" name=""method"" value=""reenforcing""/><br>");
		     Put_Line("Neural : <input type=""radio"" id=""method"" name=""method"" value=""neural""/><br>");
		     
		     
		     
		     Put_Line("<h3>Elaboration</h3>");
		     Put_Line("Ada : <input type=""checkbox"" id=""Ada"" name=""Ada"" value=""Ada"" checked><br>");
		     Put_Line("Assemblage : <input type=""checkbox"" id=""assemblage"" name=""assemblage"" value=""assemblage""><br>");
		     Put_Line("SQL : <input type=""checkbox"" id=""sql"" name=""sql"" value=""sql""><br>");
		     Put_Line("GtkAda : <input type=""checkbox"" id=""gtk"" name=""gtk"" value=""gtk"">");
		     Put_Line("<h3>Maquetage</h3>");
		     Put_Line("Manuel : <input type=""radio"" id=""maquetage"" name=""maquetage"" value=""manuel""/><br>");
		     Put_Line("Automatique : <input type=""radio"" id=""maquetage"" name=""maquetage"" value=""automatique""/>");
		     Put_Line("<h3>Interface</h3>");
		     Put_Line("Command Line : <input type=""checkbox"" id=""cmd_line"" name=""cmd_line"" value=""cmd_line""><br>");
		     Put_Line("Window : <input type=""checkbox"" id=""win"" name=""win"" value=""win""><br>");
		     Put_Line("Network : <input type=""checkbox"" id=""network"" name=""network"" value=""network""><br>");
		     Put_Line("HTML : <input type=""checkbox"" id=""html"" name=""html"" value=""html"">");
		     
		     
		 --                                                             --
		 -----------------------------------------------------------------

		  end if;
		  
		  -- Aquisition de Programmes :
		  Put_Line("<h2>Programmes(s) commandé(s)</h2>");
		  
		  Index := Natural'Input(Channel);
		  
		  
		  for I in 1..Index loop
		     declare
			Product : Product_Enum := Product_Enum'Input(Channel);
			Price   : Price_Type := 0.0;
		     begin
			
			
			   Price := Price_Type'Input(Channel);
			   
			   Command.Products(Product) := Price;
			
		     exception
			when others =>
			   null;
		     end;
		  end loop;

		  Command.HT_Sum := Price_Type'Input(Channel);
		  Command.TVA := Price_Type'Input(Channel);
		  Command.TTC_Sum := Price_Type'Input(Channel);

		  Id_Transaction := Natural'Input(Channel);
		  
		  Put_Line("Selon le taux de taxe sur la valeur ajouté, voici nos prix : <br>");
		  for Product in Product_enum loop
		     if Command.Products(Product) /= 0.0 then
			Put_Line("Product : " & To_Wide_String(Product_Enum'Image(Product)) & " := " & To_Wide_String(Price_Type'Image(Command.Products(Product))) & " € ; <br>");
		     end if;
		  end loop;
		  Put_Line("Total HT  : " & To_Wide_String(Price_Type'Image(Command.HT_Sum)) & " € ; <br>");
		  Put_Line("Total TVA : " & To_Wide_String(Price_Type'Image(Command.TVA)) & " € ; <br>");
		  Put_Line("Total TTC : " & To_Wide_String(Price_Type'Image(Command.TTC_Sum)) & " €.");
		  Put_Line("<br>");
		  Put_Line("Votre demande sera traité dans un delay de 48 à 72 heures");
		  Put_Line("<br>");		  
		  Put_Line("Merci de votre compréhension !");	       
		  Put_Line("<br>");
		  Put_Line("<br>");
		  Put_Line("<Input type=""hidden"" name=""Id_Transaction"" id=""Id_Transaction"" value=""" & To_Wide_String(Natural'Image(Id_Transaction)(2..Natural'Image(Id_Transaction)'last))& """/>");
		  Put_Line("<input type=""submit"" name=""submit"" id=""submit"" value=""Envoyer"" /> ");      
		  Put_Line("<input type=""reset"" name=""reset"" id=""reset"" value=""Effacer"" /> ");
		  
		  Put_Line("</Form>");
		  
		  
		  Put_Line("   </td></tr></table>");	       
		  Put_Line("  </td></tr></table>");	       
		  Put_Line("<a href=""/cgi-bin/webi"">Retour</a>");
		  Put_Line("</body>");
		  Put_Line("</html>");
		  
		  
	       end if;	 
	       Gnat.Sockets.Close_Socket(Socket);
	    end if;
	    
	    
	 end if;
	 
      else
	 if No_Problem then 
	    
	    Put_Line("<head>");
	    Put_Line("<meta charset=""UTF-8"">");
	    Put_Line("<title>Récapitulatif</title>");
	    Put_Line("</head>");
	    Put_Line("<body background=""/images/spectre.jpg"">");		    
	    Put_Line("<h2>Vérification</h2>");
	    Put_Line("Malgrès notre attention, notre formulaire reste inutilisé.<br>");
	    Put_Line("Vous pouvez retourner à l'adresse précédente.");
	    Put_Line("Pour vous acquiter de votre achat ; Merci de verser la somme totale sur le compte chèque postal de Manuel De Girardi à la Banque Postale.<br>");
	    Put_Line("<a href=""/cgi-bin/webi"">Retour</a>");
	    Put_Line("</body>");
	    Put_Line("</html>");      	 
	 end if;
      end if;
   end if;
   
exception
   when Program_Error =>
      
      Put_Line("<head>");
      Put_Line("<meta charset=""UTF-8"">");
      Put_Line("<title>HTTP Error ?</title>");
      Put_Line("</head>");
      Put_Line("<body>");
      Put_Line("This program is an CGI"); 
      Put_Line("</body>");
      Put_Line("</html>");
   when others =>
      Gnat.Sockets.Close_Socket(Socket);
end SaiWeb;
