-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-11 16:46:44"
-- Version := "0.0.0r"
with M.Strings;
use M.Strings;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
package M.Wopr is
   
   type User_Record is
      record
	 Logname : String_Access;
      end record;
   
   
   
   
   
   
   
   
   type T_LertCon is (DEFCON_1,
                      DEFCON_2,
                      DEFCON_3,
                      DEFCON_4,
                      DEFCON_5,
                      AD_EMERGENCY,
                      D_EMERGENCY,
                      NO_EMERGENCY);
   subtype T_Defcon is T_LertCon range DEFCON_1..DEFCON_5;
   subtype T_EmergCon is T_LertCon range AD_EMERGENCY..NO_EMERGENCY;

   
   type Nation_Enum is (None, UN, EST);
   
   type LANG_Enum is (None, EU);
   
   type Message_Type is
      record
	 Nation : Nation_Enum := None;
	 LANG   : LANG_Enum := None;
	 Valid  : Boolean := False;
      end record;
   
   
   task Message_Box is
      entry Initialize;
      entry Receive(From : in User_Record;Dest : in User_Record;Msg : in Wide_String);
      entry Get(User : in User_Record;Box : in out Wide_String_Set);
      entry Halt;
   end Message_Box;
   
   
   procedure Is_Valid (Message : out Message_Type;
		      Content : in Wide_String);
   
   protected WOPR is
      entry Set_Alert (Alert : in T_EmergCon);
      entry Raise_DefCon (DefCon : in T_DefCon);
      entry Get_Message (Line : in Wide_String;Msg : out Message_Type);
   private
      Message : Message_Type := (UN, EU, False);
      Status  : T_Lertcon := DefCon_5;
   end WOPR;
   
end M.Wopr ; 
