-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with Ada.Strings.Fixed;
use Ada.Strings;

package body M.Versions.Version_io is
   
function To_String (Version : in     Version_Type; Separator : in Character := '.') return String is
            
   begin
      
      return 	
	Integer'Image(Version.Major_Version)(2..Integer'Image(Version.Major_Version)'Last) & Separator &
	Integer'Image(Version.Minor_Version)(2..Integer'Image(Version.Minor_Version)'Last) & Separator &
	Integer'Image(Version.Revision_Version)(2..Integer'Image(Version.Revision_Version)'Last) &
        Version.release_Version;
   end To_String;   
   
   function To_Version (From : in String) return Version_Type is
      Rel   : Character := Character'Val(32);
      Rev   : Natural := 0;
      Minor : Natural := 0;
      Major : Natural := 0;
      Version : Version_Type := (0, 0, 0, 'a');
      Top     : Natural := 0;
   begin
      Top := Fixed.Index(From, ".");

      if Top /= 0 then
	 Major := Natural'Value(From(From'first..Top - 1));

	 if Fixed.Index(From, ".", Top + 1) /= 0 then

	    Minor := Natural'Value(From(Top + 1..Fixed.Index(From, ".", Top + 1)-1));

	    Top := Fixed.Index(From, ".", Top + 1) + 1;

	    Rev := Natural'Value(From(Top..From'Last-1));
	    
	    Rel := From(From'Last);
	 end if;
      end if;
      Version.Major_Version := Major;
      Version.Minor_Version := Minor;
      Version.Revision_Version := Rev;
      Version.Release_Version := Rel;
      
      
      
	return Version;
   exception
      when Constraint_Error =>
	 return Version;
   end To_Version;

end M.Versions.Version_io ; 
