-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-28 09:21:58 ; 
-- Version := 0.20.0a ; 
with M.Projects_Manager;
use M.Projects_Manager;
with M.Project;
use M.Project;
with M.Classes;
with M.Engine;
with M.Logs;
use M.Logs;
with El.Classe;
use El;
with M.Windows ;
with Ada.Containers;
use Ada.Containers;

generic
   with package Windows is new M.Windows (<>) ;
   with package Classes is new M.Classes (<>) ;
   with package Engine is new M.Engine (<>) ;
package M.Engineering is
   use Classes;
   use Engine;
   use Abstract_Vectors;
   
   
   
   type Terminal_Type is
      record
	 Root : Abstract_Access;
	 Path : Abstract_Vectors.Vector;
	 Cur  : Abstract_Access;
	 U_Count  : Natural := 0;
      end record;
   
   procedure Add_To (Terminal : in out Terminal_Type; Obj : Abstract_Access);
   function "<" (Left, Right : in Abstract_Access) return Boolean;
   package Date_Sorting is new Abstract_Vectors.Generic_Sorting("<");
   
   type Project_Type is
      record
	 Root : Element_Access;
	 Path : Element_Vectors.Vector;
	 Cur  : Element_Access;
      end record;

   type Engineering_Record is tagged limited
      record
	 ------------------------------------------------------------
	 --                Project Manager
	 
	 Projects          : Projects_Record(Project_Num_Range'Last);
	 Archives          : Projects_Record(Project_Num_Range'Last);
	 
	 ------------------------------------------------------------
	 --                Organizer
	 
	 Terminal : Terminal_Type;
	 
	 
	  
	 ------------------------------------------------------------
	 --                Engine
	 Project : Project_Type;
	 	 
	 ------------------------------------------------------------
	 --                   Master
	 Borg :  Project_Type;
	 
	 ------------------------------------------------------------
	 --                   Logs
	 Logs : Log_Array := (others => (0.0, 0.0));
	 Sessions : Session_Array;
	 
	 ------------------------------------------------------------
	 --                        Engineer                        --
	 ------------------------------------------------------------
	 --                                                        --
	 --          Self programming process of Enginner          --
	 --                                                        --
	 ------------------------------------------------------------
	 --
	 -- Editor
	 --
	 ------------------------------------------------------------
	 --
	 -- 
	 --
	 ------------------------------------------------------------
      end record;
   
   
end M.Engineering ; 
