-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-28 09:21:59 ; 
-- Version := 0.21.0a ; 
with Ada.Calendar;
use Ada.Calendar;
package body M.Engineering is
   
   function "<" (Left, Right : in Abstract_Access) return Boolean is
   begin
      if Left = null or Right = null then
	 raise Program_Error;
      end if;
      return Left.Date < Right.Date;
   end "<";
   
   
   
   procedure Add_To (Terminal : in out Terminal_Type; Obj : Abstract_Access) is
   begin
      if Terminal.Root = null then
	 Obj.Info.Index := 1;	 
	 Terminal.Root := Obj;
	 Terminal.Cur := Obj;
	 Terminal.Path := Terminal.Path & Obj;
      else
	 Obj.Info.Index := Abstract_Index(Abstract_Vectors.Length(Terminal.Cur.Childs) + 1);
	 Terminal.Cur.Childs := Terminal.Cur.Childs & Obj;
	 Terminal.Cur.Info.Childs_Num := Terminal.Cur.Info.Childs_Num + 1;
      end if;
   end Add_To;
end M.Engineering ; 
