--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------

with Gnos;
with Gnos.Windows;
with Gnos.Parameters;
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-12-06 15:54:11 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.36.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
-- Dependences : bash xterm source-highlight make tail head tar
--------------------------------------------------------------------------------------------------------------------------------------------------------------

with Text_Io;
with Gtk.Main;

procedure Gnostic is
   
   use Gnos;
   use Gnos.Parameters;
   
   End_Of_Task  : Boolean := False;
   
   Gnose_Params : aliased Gnose_Parameters_Type;
      
begin

   --Text_Io.Put_Line("Setting parameters and options from config file or command_line...");
   Parameters.Initialize(Gnose_Params, End_Of_Task);
      
   if End_Of_Task then      
      return;
   end if;
   
   Text_Io.Put_Line("You are setted this options from config file or command_line...");
   Text_Io.New_Line;
   Print_Parameters(Gnose_Params.kit);
   
   declare
      
      use Gnos.Windows;
      use Gnos.Windows.Agnose;
      -- use Gnos.Windows.Agnose.Neural;
      -- use Gnos.Windows.Agnose.Neural.Objects_System;
      -- use Gnos.Windows.Agnose.Neural.Objects_System.Objects_System;
      -- use Gnos.Windows.Agnose.Neural.Objects_System.Objects_system.Language;
      -- use Gnos.Windows.Agnose.Neural.Objects_System.Objects_System.Language.Agnose_Projects;
      
      
      Gnostic : Gnose_Access;
      Gnose_Context : constant access Gnose_Context_Record := new Gnose_Context_Record;
            	 
   begin
      
      Text_Io.Put_Line("If this options are correct then press enter, else press Ctl+D");
      Text_Io.Skip_Line;
      Text_Io.New_Line;			
      Initialize(Gnose_Context.all, Gnose_Params);   
      Text_Io.New_Line;
      Text_Io.Put_Line("Going to check parameters...");
      Text_Io.New_Line;
      if not Gnos.Windows.Agnose.Check_Parameters(Gnose_Context.all, Gnose_Params) then
	 raise Program_Error;
      end if;			
      
      Text_Io.Put_Line("This values are setted for Context use.");
      Text_Io.New_Line;
      Print_Context(Gnose_Context.all);			
      Text_Io.New_Line;
      
      Text_Io.Put_Line("If this values are correct then press enter, else press Ctl+D");
      Text_Io.Put_Line("(--Text_Io.Skip_Line)");
      
      Gtk.Main.Init; 
           
      Gnostic := Gnose_Initialize(Gnose_Context, Gnose_Params'access);      
      if Gnostic /= null and then Gnostic.Gnose_Interface /= null then
	 Gtk.Main.Main;
      else
	 raise Program_Error;
      end if;
      
   end;
   Text_Io.Put_Line("End of program.");
exception
   when Text_Io.End_Error =>
      Text_Io.Put_Line("End of program.");
   
end Gnostic;
