--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-29 04:04:12 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.20.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------

with Ada.Unchecked_Deallocation;
with Ada.Strings.Wide_Unbounded;
with Gnat.Os_Lib;
use Gnat;

package Gnos.Results is
   subtype U_String is Ada.Strings.Wide_Unbounded.Unbounded_Wide_String;
   use type U_String;
   
   function "+"(S: Wide_String) return U_String
     renames Ada.Strings.Wide_Unbounded.To_Unbounded_Wide_String;
 
   function "-"(U: U_String) return Wide_String
     renames Ada.Strings.Wide_Unbounded.To_Wide_String;
 
   type Variadic_Array is array(Positive range <>) of U_String;
   
   type Variadic_Access is access Variadic_Array;
   
   type Wide_String_Access is access all Wide_String;
   procedure Free is new Ada.Unchecked_Deallocation(Wide_String, Wide_String_Access);
   
   procedure Free is new Ada.Unchecked_Deallocation(Variadic_Array, Variadic_Access);
   
   type Wide_Result_Type is 
     abstract tagged
      record
	 File_Content   : Variadic_Access;
      end record;
   
   type Spawn_Result_Type is
     new Wide_Result_Type with
      record
	 Process_Id     : Gnat.Os_Lib.Process_Id;
	 Program_Name   : U_String;
	 Args           : Os_Lib.Argument_List_Access;	 
	 Output_File    : U_String;
	 Success        : Boolean := True;
	 Return_Code    : Integer := 0;
	 Err_To_Out     : Boolean := False;	 
      end record;
   
   
   type Search_Result_Type is
     new Wide_Result_Type with
      record
         Pattern   : Wide_String_Access := new Wide_String ' ("");
	 Address   : Os_Lib.String_Access;
         Doc_Name  : Wide_String_Access;
      end record;         
   
   
   type Result_Access is access all Wide_Result_Type'Class;
   
   function Spawn(Line : in String) return Spawn_Result_Type;
   
end Gnos.Results;
