with Gn.Identity;                       use Gn.Identity;

package Gn.Logos.Gnu_Ada is
   
   type Command_Enum is (Null_Item, Hello, bonjour);
   
   
   
   
   type Ada_Command_Record is
     tagged record
      Command : Command_Access;
      Parameters : access Gn_Dialog_Record'Class;
   end record;
   
   type Ada_Command_Access is access all Ada_Command_Record;
     
   task Dialog is
      entry Init
	(Reuse        : in     Boolean);      
      entry New_Dialog
	(Id           : in     Identity_Access);
      entry Respond
	(Line         : in out Std_String;
	 Command      :    out Ada_Command_Access);
      entry End_Dialog;
      entry Halt;
   end Dialog;
private
   function Value (Cmd : in String) return Command_Enum;
   
end Gn.Logos.Gnu_Ada;
