
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;

with Gn.Logos.X.Gtk_Lib.Hello_World;    use Gn.Logos.X.Gtk_Lib;
with Gn.Logos.X.Gtk_Lib.Bonjour_Le_Monde;
use Gn.Logos.X.Gtk_Lib.Bonjour_Le_Monde;
package body Gn.Logos.Gnu_Ada is         
         
   
   function Value (Cmd : in String) return Command_Enum is
      
      Command_Last : Natural := 0;      
   begin
      if Index(Cmd, " ") /= 0 then
	 Command_Last := Index(Cmd, " ") - 1;
      else
	 Command_Last := Cmd'Last;
      end if;
      return Command_Enum'Value(Cmd(Cmd'First..Command_Last));
   exception
      when Constraint_Error =>
	 return Null_Item;
   end Value;
   
   task body Dialog is
      
      
      
   begin
      accept Init(Reuse : in Boolean) do
	 null;
      end Init;
      
      declare
	 
	 Identity : Identity_Access;
      begin
	 loop
	    select
	       accept New_Dialog(Id     : in Identity_Access) do
		  Identity := Id;
	       end New_Dialog;
	    or
	       when Identity /= null =>
		  accept Respond
		    (Line         : in out Std_String;
		     Command      :    out Ada_Command_Access) do
		     declare
			Command_Name : Command_Enum := Null_Item;
		     begin
			Command_Name := Value(Line);
			case Command_Name is
			   when Hello =>
			      Command := new Ada_Command_Record;
			      Command.Parameters := new Gn_Dialog_Record;
			      Command.Command := Hello_World.Gtk_New'Access;
			   when Bonjour =>
			      Command := new Ada_Command_Record;
			      Command.Parameters := new Gn_Dialog_Record;
			      Command.Command := Bonjour_Le_Monde.Gtk_New'access;
			   when others =>
			      Command := null;
			end case;
		     end;
		  end Respond;
	    or
	       accept End_Dialog do		  
		  Identity := null;
	       end End_Dialog;
	    or
	       accept Halt;
	       exit;	 
	    end select;
	 end loop;
      end;
   end Dialog;
   
end Gn.Logos.Gnu_Ada;
