
with Gmface.Gm_Common;                    use Gmface.Gm_Common;
with Gmface.Gm_Virtual;                   use Gmface.Gm_Virtual;
with Gmface.Gm_MIDI.Messages;             use Gmface.Gm_MIDI.Messages;
with Gmface.Gm_Virtual.Gmface.Gmface_Plugins;
use Gmface.Gm_Virtual.Gmface.Gmface_Plugins;

package Gmface.Gm_Virtual.Gmface.Step_Sequencer is
   
   type Voice_Type is tagged
      record
	 Id      : Positive := 1;
	 Key     : Value_Type := 36;
	 Sens    : Value_Type := 95;
	 Length  : Value_Type := 2;
	 Bar     : Positive := 1;
	 Number  : Time_Number_Type := 1;
	 Step    : Time_Unit_Type := 1;
	 Played  : Boolean := False;
	 Note    : String_Access := new String ' ("");
	 Octave  : Value_Type := 0;
	 In_Loop : Boolean := False;
      end record;
   
   type Step_Array_Type is array (Positive range <>) of Voice_Type;
   
   
   type Step_Seq_Plugin_Record is
     new Gmface_Plugin_Class(Step_seq) with
      record
	 Sequencer : Step_Array_Type(1..128);
	 Bars_Max  : Positive := 8;
      end record;
   
   procedure Print (Filename : in String; Plug : in Step_Seq_Plugin_record);
   
end Gmface.Gm_Virtual.Gmface.Step_Sequencer;
