-----------------------------------------------------
-- porttime is Ada binding to C library "porttime".
-----------------------------------------------------
--  Copyright (C) 2010 Manuel De Girardi.

--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.

--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.

--  You should have received a copy of the GNU General Public License
--  along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- French translation --

-----------------------------------------------------
-- porttime is Ada binding to C library "porttime".
-----------------------------------------------------
--  Copyright (C) 2010 Manuel De Girardi.

--  Ce programme est un logiciel libre ; vous pouvez le redistribuer ou le
--  modifier suivant les termes de la ?GNU General Public License? telle que
--  publiée par la Free Software Foundation : soit la version 3 de cette
--  licence, soit (à votre gré) toute version ultérieure.

--  Ce programme est distribué dans l?espoir qu?il vous sera utile, mais SANS
--  AUCUNE GARANTIE : sans même la garantie implicite de COMMERCIALISABILITÉ
--  ni d?ADÉQUATION À UN OBJECTIF PARTICULIER. Consultez la Licence Générale
--  Publique GNU pour plus de détails.

--  Vous devriez avoir reçu une copie de la Licence Générale Publique GNU avec
--  ce programme ; si ce n?est pas le cas, consultez :
--  <http://www.gnu.org/licenses/>.

-----------------------------------------------------
-- Author      : Manuel De Girardi
-- Date        : 2012/07/14
-- Version     : 0.0.2
-- unit type   : specification
-- Description : Ada binding to C library "porttime".
-----------------------------------------------------
with Interfaces.C;
with System;

package Gmface.Gm_MIDI.Porttime is

   type PtError is(PtNoError,
                   PtHostError,
                   ptAlreadyStarted,
                   ptAlreadyStopped,
                   PtInsufficientMemory);


   function Pt_Start(Resolution : Integer;
                     PtCallback : System.Address;
                     UserData : System.address) return PtError;
   pragma Import (C, Pt_Start, "Pt_Start");

   function Pt_Time return Interfaces.C.Long;
   pragma Import (C, Pt_Time, "Pt_Time");

   type Time_Access is access function return Interfaces.C.Long;
   pragma Convention(C, Time_Access);
end Gmface.Gm_MIDI.Porttime;
