with Interfaces.C;                      use Interfaces;
package Gmface.Gm_MIDI.Messages is
   
   
   subtype Channel_Type is Interfaces.C.Long range 0..15;
   -- valeurs admises pour le spécification des cannaux MIDI.   
   
   subtype Value_Type is Interfaces.C.Long range 0..127;
   -- Valeurs admises dans pour les paramettres du type notes et quelque construction de message.
   
   subtype Bank_Type is Interfaces.C.Long range 0..127;
   -- Valeurs admises pour les changements de banque.
   
   subtype Program_Type is Interfaces.C.Long range 0..127;
   -- Valeurs admises pour les changements de programme.
   
   
   type Message_Type is
      record
         Status : Interfaces.C.Long := 0;
         Data1 : Interfaces.C.Long := 0;
         Data2 : Interfaces.C.Long := 0;
      end record;
   -- Définit un message sous forme de 3 octets.
   
   function To_Long(Message : in Message_Type) return C.Long;
   -- Transforme un message sous forme de 3 octets en un Long.   
   
   function Message(Status, Data1, data2 : in C.Long) return Message_Type;
   -- Construit un message de 3 octets.
   
   function Note_On(Channel : in Channel_Type;
                    Note : in Value_Type;
                    Sens : in Value_Type) return Message_Type;
   -- Construit un message "note_on".

   function Note_Off (Channel : in Channel_Type;
                      Note : in Value_Type) return Message_Type;
   -- Construit un message "note_off".

   function All_Note_Off(Channel : in Channel_Type) return Message_Type;
   -- Construit un message "all_note_off".

   function Bank_Select_MSB(Channel : in Channel_Type;
                            Bank : in Bank_Type) return Message_Type;
   -- Construit un message de selection de banque MSB.

   function Bank_Select_LSB(Channel : in Channel_Type;
                            Bank : in Bank_Type) return Message_Type;
   -- Construit un message de selection de banque LSB.
   
   function Program_Change(Channel : in Channel_Type;
			   Program : in Program_Type) return Message_Type;
   -- Construit un message de changement de programme.
   
   function NRPM_MSB (Channel : in Channel_Type;
                      Value : in Value_Type) return Message_Type;
   -- Construit un message NRPM MSB.
   
   function NRPM_LSB (Channel : in Channel_Type;
                      Value : in Value_Type) return Message_Type;
   -- Construit un message NRPM LSB.
   
   function Data_Entry_MSB (Channel : in Channel_Type;
                            Value : in Value_Type) return Message_Type;
   -- Construit un message Data Entry MSB.   

   function Aftertouch(Channel : in Channel_Type;
                       Value : in Value_Type) return Message_Type;
   -- Construit un message Aftertouch.
   
   function PitchBend(Channel : in Channel_Type;
                      Data1 : in Value_Type;
                      Data2 : in Value_Type) return Message_Type;
   -- Construit un message PitchBend.
   
   function ControlCommand(Channel : in Channel_Type;
                           Data1 : in Value_Type;
                           Data2 : in Value_Type) return Message_Type;
   -- Construit un message de commande de contrôle.
   

   -- The next function are not implemented.
   Arp_Type_up : constant Natural := 16#0#;
   Arp_Type_down : constant Natural := 16#15#;
   Arp_Type_alt1 : constant Natural := 16#2A#;
   Arp_Type_alt2 : constant Natural := 16#3F#;
   Arp_Type_random : constant Natural := 16#54#;
   Arp_Type_trigger : constant Natural := 16#69#;
   function Arp_Type_Switch(Channel : in Channel_Type;
                            Switch : in Natural) return Message_Type;

   subtype T_Arp_Gate is Natural range 0..127;
   function Arp_Gate(Channel : in Channel_Type;
                     Gate : in T_Arp_Gate) return Message_Type;

   Arp_Select_Off : constant Natural := 0;
   Arp_Select_arp : constant Natural := 1;
   Arp_Select_Step_Seq_1 : constant Natural := 2;
   Arp_Select_Step_Seq_2 : constant Natural := 3;

   function Arp_Select(Channel : in Channel_Type;
                       Switch : in Natural) return Message_Type;

   function Step_Seq_1_Latch_Off return Message_Type;
   function Step_Seq_1_Latch_On return Message_Type;

   subtype T_Step_Seq_1_Gate is Natural range 0..127;
   function Step_Seq_1_Gate(Gate : in T_Step_Seq_1_Gate) return Message_Type;

   Step_Seq_2_Latch_off : constant Natural := 0;
   Step_Seq_2_Latch_on  : constant Natural := 127;

   subtype T_Step_Seq_2_Gate is Natural range 0..127;
   function Step_Seq_2_Gate(Gate : in T_Step_Seq_2_Gate) return Message_Type;
   
end Gmface.Gm_MIDI.Messages;
