------------------------------------------------------------------------------
-- Gmface-Gm_Application-Gtk_Interface : GtkAda Gm interface of Gmface.     --
------------------------------------------------------------------------------
with Gmface.Gm_Midi.Instruments;        use Gmface.Gm_Midi.Instruments;

with Gmface.Gm_Virtual;                 use Gmface.Gm_Virtual;
with Gmface.Gm_Processing.Gm_Work_Processing;
use Gmface.Gm_Processing.Gm_Work_Processing;

with Gmface.Gm_Application.Gtk_Plugins_Specifications;
use Gmface.Gm_Application.Gtk_Plugins_Specifications;


with System.Address_To_Access_Conversions;
with GtkAda.Application;                use GtkAda.Application;
with Gmface.Gm_Application.Gm_Interface;use Gmface.Gm_Application.Gm_Interface;

with Gtk.Application_Window;            use Gtk.Application_Window;


with Gtk.Paned;                         use Gtk.Paned;
with Gtk.Frame;                         use Gtk.Frame;
with Gtk.Tree_Model;                    use Gtk.Tree_Model;
with Gtk.Tree_View;                     use Gtk.Tree_View;
with Gtk.Tree_Store;                    use Gtk.Tree_Store;

with Gtk.Gentry ;                       use Gtk.Gentry;
with Gtk.Check_Button;                  use Gtk.Check_Button;
with Gtk.Label;                         use Gtk.Label;

with Gtk.Combo_Box_Text;                use Gtk.Combo_Box_Text;
with Gtk.Button;                        use Gtk.Button;
with Gtk.Spin_Button;                   use Gtk.Spin_Button;

with Gtk.Window;                        use Gtk.Window;
with Gtk.Box;                           use Gtk.Box;
with Gtk.Notebook;                      use Gtk.Notebook;

with Gtk.Action_Group;
pragma Elaborate_All(Gtk.Action_Group);
use Gtk.Action_Group;

with Gtk.UI_Manager;                    use Gtk.UI_Manager;

with Glib.Main;                         use Glib.Main;

package Gmface.Gm_Application.Gtk_Interface is
   
   
   
   
   type Plugin_Page_Access is access all Plugin_Page_Type;
   
   type Plugins_Pages_Set is array (Plugin_num'range) of Plugin_Page_Access;
   
   
   
   
   type Gtk_Work_Window_Record is tagged
      record	 
	 
	 Window : Gtk_Application_Window;
	 
	 Main_Vbox          : Gtk_Vbox;
	 
	 
	 Menus_Hbox         : Gtk_Hbox;
	 
	 App_Action_Group   : Gtk_Action_Group;
	 App_UI             : Gtk_UI_Manager;	 
	 
	 Win_Action_Group   : Gtk_Action_Group;
	 Win_UI             : Gtk_UI_Manager;
	 
	 Process             : Work_Processing_Access;
      end record;
   
   type Gtk_Gmface_Work_Window_Record(Work : Work_Access;
				      Work_Id : Work_Num) is new Gtk_Work_Window_Record with
      record
	 Master_Frame                : Gtk_Frame;
	 Master_Box                  : Gtk_Box;
	 Signature                   : Gtk_Entry;
	 Tempo_Button                : Gtk_Spin_Button;
	 Track_length_Button         : Gtk_Spin_Button;
	 Played_Form                 : Gtk_Combo_Box_Text;
	 
	 Flow_Frame                  : Gtk_Frame;	 
	 Flow_Model                  : Gtk_Tree_Store;
	 Flow_Tree                   : Gtk_Tree_View;
	 Iter                        : Gtk_Tree_Iter;   
	 Line_Counter                : Natural := 0;
	 
	 
	 Devices_Frame               : Gtk_Frame;
	 Devices_Model               : Gtk_Tree_Store;
	 Devices_Tree                : Gtk_Tree_View;
	 
	 Plugins_Frame               : Gtk_Frame;
	 Plugins_Model               : Gtk_Tree_Store;
	 Plugins_Tree                : Gtk_Tree_View;
	 Plugins_Pages               : Plugins_Pages_Set;
	 
	 
	 Flow_Paned                  : Gtk_Hpaned; -- between device and flow
	 
	 Main_Paned                  : Gtk_Vpaned; -- between Plugin and Hpanned.
	 
	 State_Frame                 : Gtk_Frame;
	 State_Box                   : Gtk_Hbox;	 	 
	 Media_Play                  : Gtk_Button;
	 Media_Stop                  : Gtk_Button;
	 In_Loop                     : Gtk_Check_Button;	 
	 Elapsed                     : Gtk_Entry;	 	 
	 Position                    : Gtk_Entry;
	 State_Vbox                  : Gtk_Box;
	 Tools_Box                   : Gtk_Box;            
	 State_Label                 : Gtk_Label;            
	 Modulation_Play_On          : Gtk_Button;
	 Modulation_Play_Off         : Gtk_Button;
	 Modulation_Record_On        : Gtk_Button;
	 Modulation_Record_Off       : Gtk_Button;            
	 Mod_Reset                   : Gtk_Button;
      	 
	 
	 Main_Hbox                   : Gtk_Hbox;	 	 	 
	 
	 Flow_Control                : Glib.Main.G_Source_Id :=
	   Glib.Main.No_Source_Id;
	 State_Control               : Glib.Main.G_Source_Id :=
	   Glib.Main.No_Source_Id;
   
      end record;
   
   type Gtk_Gmidi_Work_Window_Record(Work_Id : Work_Num) is new Gtk_Work_Window_Record with
      record
	 null;
      end record;
      
   package Gtk_Work_Window_Conversions
   is new System.Address_To_Access_Conversions
     (Gtk_Work_Window_Record'Class);
   
   subtype Gtk_Work_Window_Pointer is Gtk_Work_Window_Conversions.Object_Pointer;
   
   type Gtk_Work_Window_Array is array (Positive range <>) of Gtk_Work_Window_Pointer;
   
   type Device_Page_record is tagged
      record
	 Input_Device  : Gtk_Combo_Box_Text;
	 Output_Device : Gtk_Combo_Box_Text;
      end record;   
   type Device_Page_Access is access all Device_Page_Record;
   
   type Device_Page_Array is array (Positive range <>) of Device_Page_Access;
   
   type Gtk_Application_Record is tagged
      record
	 Gm_Application  : Gm_Interface.Gm_Interface;
	 Devices_Pages   : Device_Page_Array(1..128);
	 Bandmaster      : aliased Bandmaster_Record(128);
	 Notebook        : Gtk_Notebook;
	 Cur_Page        : Integer := 0;
	 Works_Processes  : Work_Process_Array;	 
      end record;
   
   type Gtk_Interface_Record is new Gtk_Application_Record With
      record
	 Application       : GtkAda_Application;	 
	 Window            : Gtk_Window;
	 Gtk_Works_Windows : Gtk_Work_Window_Array(1..128);
	 In_Loop           : Boolean := False;
	 Auto_Play         : Boolean := False;
	 Cur_Win           : Positive := 1;
	 -- Current Work on play list.
	 
	 
	 Works             : Work_Array;
	 Work_Last         : Natural := 0;
	 Cur_Window        : Positive := 1;
	 -- Current Window when activate-focus sended.
	 
	 
	 Main_Automation   : G_Source_Id;
      end record;
   
   type Gtk_Interafce is access all Gtk_Interface_Record;
   
   package Gtk_Interface_Conversions
   is new System.Address_To_Access_Conversions
     (Gtk_interface_Record);
   
   subtype Gtk_Interface_Pointer is Gtk_Interface_Conversions.Object_Pointer;
   
   procedure Gtk_New(Gtk_Int   : out Gtk_Interface_Pointer;
		     Works     : access Work_Array;
		     Auto_Play : in Boolean;
		     In_Loop   : in boolean);
   
   
private
   
   GApplication_Id : constant String := "gmface.gm_applications.gtk_interface";
   
   
   package Main_Sources is new Glib.Main.Generic_Sources(Gtk_Interface_Pointer);
end Gmface.Gm_Application.Gtk_Interface;
