-- aish is another attempt of A. i. written with Ada.
-- Aish is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-04-29 20:25:34"
-- Version := "1.1.0r"
package Ai.Versions is
   
   subtype Major_Version_Type is Natural range Natural'First .. 2399;
   subtype Minor_Version_Type is Natural range Natural'First .. 255;
   subtype Revision_Version_Type is Natural range Natural'First .. 1023;
   subtype Release_Version_Type is Character range 'a' .. 'z' ; 
         
   -- Initiale version :
   Current_Major    : constant Major_Version_Type    := 2 ; 
   Current_Minor    : constant Minor_Version_Type    := 2 ; 
   Current_Revision : constant Revision_Version_Type := 0 ; 
   Current_Release  : constant Release_Version_Type  := 'r' ; 
      
   type Version_Type is
      record
	 Major_Version    : Major_Version_Type := Major_Version_Type'First;
	 Minor_Version    : Minor_Version_Type := Minor_Version_Type'First;
	 Revision_Version : Revision_Version_Type := Revision_Version_Type'First;
	 Release_Version  : Release_Version_Type := Release_Version_Type'First;
      end record;
   
   Null_Version : constant Version_Type := 
     (Major_Version => Major_Version_Type'First,
      Minor_Version => Minor_Version_Type'First,
      Revision_Version => Revision_Version_Type'First,
      Release_Version => Release_Version_Type'First);

   Version : Version_Type := 
     (Major_Version => Current_Major,
      Minor_Version => Current_Minor,
      Revision_Version => Current_Revision,
      Release_Version => Current_Release);
   
   
   New_Action      : Boolean := False;
   New_Description : Boolean := False;
   New_Version     : Boolean := False;

   
end Ai.Versions ; 
