-- aish is another attempt of A. i. written with Ada.
-- Aish is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-04-29 20:25:34"
-- Version := "1.1.0r"

with Gnat.Os_Lib;
with Ada.Strings.Wide_Unbounded;
with Ada.Unchecked_Deallocation;

package Ai.Shell is
   
   use Gnat.Os_Lib;   
   use Ada.Strings;

   function Internal_Cmd_Value (Line : in String) return Int_Cmd_Enum;
   
   function Command_Name (Line : in String) return String;
   
   
   type Wide_String_Access is access all Wide_String;
   procedure Wide_Free is new Ada.Unchecked_Deallocation (Wide_String, Wide_String_Access);
   
   subtype U_String is Ada.Strings.Wide_Unbounded.Unbounded_Wide_String;
   use type U_String;
   
   function "+"(S: Wide_String) return U_String
     renames Ada.Strings.Wide_Unbounded.To_Unbounded_Wide_String;
 
   function "-"(U: U_String) return Wide_String
     renames Ada.Strings.Wide_Unbounded.To_Wide_String;
 
   type U_Array is array(Positive range <>) of U_String;
   
   type U_array_Access is access U_Array;
   
   procedure U_array_Free is new Ada.Unchecked_Deallocation 
     (U_Array, U_Array_Access);
   
   
   type Result_Enum is (File, Search, Spawn);
   
   type Result_Record (Name : Result_Enum) is tagged
      record
	 Wlines : U_Array_Access;
	 Count  : Natural := 0;
	 Initialized : Boolean := False;
	 case Name is
	    when File =>
	       null;
	    when Search =>
	       Pattern   : Wide_String_Access := new Wide_String ' ("");
	       Address   : String_Access;
	       Doc_Name  : Wide_String_Access;
	    when Spawn =>
	       Process_Id     : Gnat.Os_Lib.Process_Id;
	       Program_Name   : U_String;
	       Args           : Argument_List_Access;	 
	       Output_File    : U_String;
	       Success        : Boolean := False;
	       Return_Code    : Integer := 0;
	       Err_To_Out     : Boolean := False;	 
	 end case;
	 
      end record;   
            
   type Wide_Result_Access is access all Result_Record'Class;
   
   procedure Wide_Result_Free is new Ada.Unchecked_Deallocation(Result_Record'Class, Wide_Result_Access);
   
   type Spawn_Result_Record is new Result_Record(Spawn) with null record;
   type File_Result_Record is new Result_Record(File) with null record;
   type Search_Result_Record is new Result_Record(Search) with null record;

   
   function Delete_Local_Prefix(Filename : in String) return String;
   function Normalize_Quoted_Argument(Arg : in String) return String;
   function Search_Regexp (Path : in String;
                           Pattern : in String) return String;
   function Expand_filename (Line : in String) return String;
   procedure Change_directory (Line : in String;Old_Pwd : in out String_Access);
   procedure Find_At_Path (Path : in String;
			   Pattern : in String;
			   Result : in Wide_Result_Access);
   procedure Completion (Line : in String;
			 Full_Command : out Wide_String_Access;
			 Result : out Wide_Result_Access);
   
   type All_Types is tagged
      record
	 Boo  : Boolean;
	 Int  : Integer;
	 Flt  : Float;	    
	 Str  : String_Access;	    
      end record;
   
   type attribut_Enum is (Nil, Boo, Int, Flt, Str);
   
   type Attribut_Record is new All_Types with
      record
	 Tags  : String_Access;
	 Value : String_Access;
	 Enum  : Attribut_Enum;
      end record;            
   
   
   
   type Attribut_Array is array (Positive range <>) of Attribut_Record;
   
   type Attributs (Max : Positive) is
      record
	 List : Attribut_Array(1..Max);
	 Index : Natural := 0;
      end record;

   procedure Parse (Line : in String; Name : out String_Access; Image : out String_Access);
   
   function Make (Names : in String; Value : in String) return Attribut_Record;
   function names (Att : in Attribut_Record) return String;
   function images (Att : in Attribut_Record) return String;
   
   
   procedure Alias (Line : in String; Alias_Set : in out Attributs);
   procedure Unalias (Line : in String; Alias_Set : in out Attributs);
   
   procedure Set (Line : in String; Var_Set : in out Attributs);
   procedure Unset (Line : in String; Var_Set : in out Attributs);
   
   procedure Put(Name : in String;  Var_Set : in out Attributs);
   
   procedure Put_Line(Name : in String;  Var_Set : in out Attributs);
   
   subtype Line_Index_Range is Natural range 0..132072;
   type Wide_String_Array is array (Line_Index_Range range <>) of Wide_String_Access;
   type Wide_String_Set (Lines_Max : Line_Index_Range) is tagged
      record
	 Lines : Wide_String_Array(1..Lines_Max);
	 Line_Last : Natural := 0;	     
      end record;   
   
   procedure Add_Line (Set : in out Wide_String_Set;
		       Last : in out Line_Index_Range;
		       Line : in Wide_String);
   procedure Set_Free(Set : in out Wide_String_Set);
   
   
   
end Ai.Shell ; 
