-- aish is another attempt of A. i. written with Ada.
-- Aish is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-04-29 20:25:34"
-- Version := "1.1.0r"
with Ada.Wide_Text_Io;
with Ada.Text_Io;
with Gnat.Command_Line;
use Gnat;
use Ada;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.UTF_Encoding.Strings;
use Ada.Strings.UTF_Encoding.Strings;
with Ai.Errors;
use Ai.Errors;
package body Ai.Options is
   function Get_Options_From_Command_Line
     -- To get Options_Kit_array_Type from argument in command_line ;
     
     return Options_Kit is
      
      Kit : constant Options_Kit := Full_Line_Options_Kit;
      
   begin
      -- D'abord je traite les arguments de la ligne de commande ;                 --
  Opt :
      loop	 
	 begin
	    loop
	       begin
		  --case Command_Line.Getopt ("o x q h v w W F: f: R: r: l: m: M: c: C: i: n N U: s: S: e: H: P p d: t:") is
		  
		  case Command_Line.Getopt ("h v F: N: i: a: r: t") is
		     when ASCII.NUL => exit Opt;
			
		     when 'F' =>
			if Command_Line.Full_Switch /= "F" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Kit(Config_Filename).Is_Setted := True;
			Kit(Config_Filename).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
			
		     when 'h' =>
			if Command_Line.Full_Switch /= "h" then		     
			   raise Command_Line.Invalid_Switch;
			end if;
			Kit(Help).Is_Setted := True;		  
		     when 'v' =>
			if Command_Line.Full_Switch /= "v" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Kit(Version).Is_Setted := True;		  
		     when 'N' =>
			if Command_Line.Full_Switch /= "N" then
		     	   raise Command_Line.Invalid_Switch;
		     	end if;
		     	Kit(Term_name).Is_Setted := True;			
		     	Kit(Term_name).Value :=
		     	  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
			
		     when 'i' =>
			if Command_Line.Full_Switch /= "i" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Kit(initialize).Is_Setted := True;
			Kit(initialize).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));			
		     when 'a' =>
			if Command_Line.Full_Switch /= "a" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Kit(Add).Is_Setted := True;
			Kit(Add).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));			
		     when 'r' =>
			if Command_Line.Full_Switch /= "r" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Kit(Remove).Is_Setted := True;
			Kit(Remove).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));			
		     when 't' =>
			if Command_Line.Full_Switch /= "t" then		     
			   raise Command_Line.Invalid_Switch;
			end if;
			Kit(Total).Is_Setted := True;		  
		     when others =>
			raise Program_Error;         -- cannot occur!
		  end case;
		  
		  
	       exception
		  when Command_Line.Invalid_Switch    => Text_Io.Put_Line ("Invalid Switch " & Command_Line.Full_Switch);
		     
		     raise;
		     
		  when Command_Line.Invalid_Parameter =>
		     
		     raise Spec_Error;
		     		  
	       end;
		  
	    end loop;      
	 exception
	    when Spec_Error =>
	       Text_Io.Put_Line ("No parameter for " & Command_Line.Full_Switch);
	       raise;
	       
	 end;
      end loop opt;
      
      return Kit;
      

      
      
   end Get_Options_From_Command_Line;
   -- return Options_Kit;
   
   
   function Get_Options_From_File
     (Filename : in Wide_String)
     -- To get Options_Kit_array_Type from argument in file ;
     
     return Options_Kit is
      Kit : constant Options_Kit := Full_File_Options_Kit;
      File : Wide_Text_Io.File_Type;
   begin     
      
      Wide_Text_Io.Open(File, Wide_Text_Io.In_File, To_String(Filename));
      while not Wide_Text_Io.End_Of_File(File) loop

	 declare
	    Line   : constant Wide_String := Wide_Text_Io.Get_Line(File);
	    Switch : constant Character := To_Character(Line(Line'First));
	    Parameter : access String;
	 begin
	    
	    if Line'Length > 1 then
	       Parameter := new String ' (To_String(Line(Line'First+1..Line'last)));
	    end if;
	    
	    case Switch is
	    
	       when 'F' =>
		  
		  Kit(Config_Filename).Is_Setted := True;
		  Kit(Config_Filename).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
		  
	       when 'h' =>
		  
		  Kit(Help).Is_Setted := True;
		  
	       when 'v' =>
		  
		  Kit(Version).Is_Setted := True;
		  
	       when 'N' =>		  
		     
		     Kit(Term_name).Is_Setted := True;
		     Kit(Term_name).Value :=
		       new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
		     
	       when 'i' =>
		     
		     Kit(Initialize).Is_Setted := True;
		     Kit(Initialize).Value :=
		       new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'a' =>
		     
		     Kit(Add).Is_Setted := True;
		     Kit(Add).Value :=
		       new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'r' =>
		     
		     Kit(Remove).Is_Setted := True;
		     Kit(Remove).Value :=
		       new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 't' =>
		  Kit(Total).Is_Setted := True;

	       when others =>
		  null;
	    end case;

	    
	 end;
      end loop;

      
      
      Wide_Text_Io.Close(File);
     return Kit;
   end Get_Options_From_File;
   -- return Options_Kit;  

end Ai.Options ; 
