-- aish is another attempt of A. i. written with Ada.
-- Aish is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-04-29 20:25:34"
-- Version := "1.1.0r"
with Ai.Parameters ;
with Ai.Options ;


package Ai.Interfaces is
   
   type Interface_Record is tagged limited
      record
	 Kit_Options : Options.Options_Kit;
	 Kit_Parameters : Parameters.Parameters_Kit;
     end record;
   
   function Get_Parameter
     (From : in Interface_Record;
      Flag : in Flag_Enum)
     return Parameters.Parameter_Record;   
   
   
   procedure Parameters_Descriptions
     (From : in Interface_Record);

   procedure Initialize (Main_Interface : in out Interface_Record'Class);
   
   procedure Print_Parameters (Interf : in Interface_Record'class);
private   
   procedure Set_Parameters
     (Kit_Parameters : out Parameters.Parameters_Kit;			    
      Kit_Options : in Options.Options_Kit);
   
   function Set_Parameters_From
     
     (Filename : in Wide_String) 
     
     return access Parameters.Parameters_Kit;      

end Ai.Interfaces ; 
