-- aish is another attempt of A. i. written with Ada.
-- Aish is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-04-29 20:25:34"
-- Version := "1.1.0r"
with Ada.Wide_Text_Io;
with Ada.Text_Io;
use Ada;
with Ada.Characters.Handling;
use Ada.Characters;
with Gnat.Command_Line;
use Gnat;
with Ai.Versions.Version_Io;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
package body Ai.Interfaces is
   function Get_Parameter
     (From : in Interface_Record;
      Flag : in Flag_Enum)
     return Parameters.Parameter_Record is
      
   begin
      return From.Kit_Parameters(Flag).all;
   end Get_Parameter;
   
   
   procedure Print_Parameters (Interf : in Interface_Record'class) is
   begin
      for Option_Flag in Flag_Enum'range loop	 
	 case Option_Flag is	    
	    when None =>
	       null;
	    when others =>	       
	       if Interf.Kit_Parameters(Flag_Enum'Value(Flag_Enum'Image(Option_Flag))).Is_Setted and		 
		 Interf.Kit_Parameters(Flag_Enum'Value(Flag_Enum'Image(Option_Flag))).Requiered_Parameter then
		  declare
		     Parameter : constant Wide_String := 
		       Interf.Kit_Parameters
		       (Flag_Enum'Val(Flag_Enum'Pos(Flag_Enum'Value(Flag_Enum'Image(Option_Flag))))).Value.all;
		  begin
		     Wide_Text_Io.Put_Line
		       (Handling.To_Wide_String
			  (
			   Flag_Enum'Image(Flag_Enum'Value(Flag_Enum'Image(Option_Flag)))) &
			  " setted with parameter : " & 
			  "" & Parameter & "" & " ; ");
		  end;
	       elsif  Interf.Kit_Parameters(Flag_Enum'Value(Flag_Enum'Image(Option_Flag))).Is_Setted then		  
		  Wide_Text_Io.Put_Line
		    (Handling.To_Wide_String(Flag_Enum'Image(Flag_Enum'Value(Flag_Enum'Image(Option_Flag)))) &
		       " setted without parameter.");		  
	       end if;
	 end case;
	 
      end loop;
   end Print_Parameters;
   
   
   procedure Parameters_Descriptions
     (From : in Interface_Record) is
   begin
      Wide_Text_Io.Put_Line("Help: aish [ Options [ Parameters ] ]");
      Wide_Text_Io.Put_Line("Help: Options : ");
      for Parameter_Flag in Config_Filename..Flag_Enum'Last loop
	 declare
	    Parameter : constant Parameters.Parameter_Record :=
	      Get_Parameter(From, Parameter_flag);
	 begin	    
	    if Parameter.Switch /= null then
	       Wide_Text_Io.Put('-' & Parameter.Switch.all & " : ");
	    end if;
	    if Parameter.Descr /= null then
	       Wide_Text_Io.Put(Parameter.Descr.all & " => ");
	    end if;
	    if Parameter.Requiered_Parameter then
	      if Parameter.param /= null then
	       Wide_Text_Io.Put(Parameter.Param.all);
	      end if;
	    end if;
	 end;
	 Wide_Text_Io.New_Line;
      end loop;
      
   end Parameters_Descriptions;


   procedure Initialize (Main_Interface : in out Interface_Record'Class) is
      Kit_Options : access Options.Options_Kit;	   
   begin
      Kit_Options := new Options.Options_Kit ' (Options.Get_Options_From_Command_Line);
      
      case Kit_Options(Config_Filename).Is_Setted is
	 when False =>
	    if Is_Regular_File(".config_file") then
	       Main_Interface.Kit_Parameters := Set_Parameters_from(".config_file").all;
	    else
	       Main_Interface.Kit_Parameters := Parameters.Line_Parameters;
	    end if;
	    
	 when True =>
	    
	    Main_Interface.Kit_Parameters := Set_Parameters_from(Kit_Options(Config_Filename).Value.all).all;
      end case;
      
      declare
	 Kit_Parameters : Parameters.Parameters_Kit := Parameters.Line_Parameters;
      begin
	 
	 Set_Parameters(Kit_Parameters, Kit_Options.all);
	 
	 for Parameter_Id in Flag_Enum'Val(1) .. Flag_Enum'Last loop
	    if Kit_Parameters(Parameter_Id).Is_Setted then
	       Main_Interface.Kit_Parameters(Parameter_Id).all := 
		 Kit_Parameters(Parameter_Id).all;
	    end if;
	 end loop;
	 
      end;
   exception      
      when Command_Line.Invalid_Parameter =>
	 Wide_Text_Io.Put_Line("Exception in initialization of Main_Interface.");
	 raise;	 
      when others =>
	 Wide_Text_Io.Put_Line("Other error in initialization of Main_Interface.");
	 raise;
   end Initialize;
   

   procedure Set_Parameters
     (Kit_Parameters : out Parameters.Parameters_Kit;			    
      Kit_Options : in Options.Options_Kit) is
   begin
      for Option_Flag in Flag_Enum'range loop
	 
	 case Option_Flag is
	    
	    when none =>
	       
	       null;
	    when others =>
	       
	       Kit_Parameters
		 
		 (
		  
		  Flag_Enum'Val
		    
		    (
		     
		     Flag_Enum'Pos(Option_Flag)
		       
		    )
		    
		 ).Is_Setted := 
		 
		 Kit_Options(Option_Flag).Is_Setted;
	       
	       
	       if Kit_Options(Option_Flag).Is_Setted then
		  case Option_Flag is
		     when others =>
			null;
		  end case;
	       end if;
	       
	       if Kit_Options(Option_Flag).Is_Setted and
		 
		 Kit_Options(Option_Flag).Requiered_Parameter  then
		  
		  Kit_Parameters
		    
		    (
		     
		     Flag_Enum'Val
		       
		       (
			
			Flag_Enum'Pos(Option_Flag)
			  
		       )
		       
		    ).Value :=
		    
		    new Wide_String ' 
		    
		    (
		     
		     Kit_Options(Option_Flag).Value.all
		       
		    );
	       end if;
	       
	 end case;
	 
      end loop;

   end Set_Parameters;
   
   function Set_Parameters_From
     
     (Filename : in Wide_String) 
     
     return access Parameters.Parameters_Kit is

      Kit_Parameters : constant access Parameters.Parameters_Kit :=
   	new Parameters.Parameters_Kit ' 
	(Parameters.File_Parameters);
      --(All_Parameters => Set_Parameters_From(Get_Options_From_File(Filename)).All_parameters);
      
      Kit_Options : access Options.Options_Kit;	   
                  
   begin
      Kit_Options := new Options.Options_Kit ' (Options.Get_Options_From_File(filename));      
      Set_Parameters(Kit_Parameters.all, Kit_Options.All);
      return Kit_Parameters;

      
   end Set_Parameters_From;

end Ai.Interfaces ; 
