package Libsens.Virtual is
   
   pragma Pure (Libsens.Virtual);      
   
   
   
   
      -- Form index.
   type Form_Index_Type is new Positive range 1..8;
   
   -- The forms used on mixed forms.
   type Forms_Names_Set_Type is array (Form_Index_Type) of access String;
   
   Forms_Names_Set : constant Forms_Names_Set_Type := 
     (
      new String ' ("Minimal"),      
      new String ' ("Hard tech"),                  
      new String ' ("Acid"),
      new String ' ("Transe"),      
      new String ' ("Techno"),
      new String ' ("Tribe"),      
      new String ' ("Drums and Bass"),
      new String ' ("Hard Core"));
      
   
   -- Mixed forms type.
   type Mixed_Form_Type is (Fusion, Fission, Unmixed, Silence);
   
   type Category_Index_Type is new Positive range 1..16;
   
   type Categories_Set_Type is array (Category_Index_Type range <>) of access String;
   
   
   Categories_Default : constant Categories_Set_Type(1..16) :=
     (new String ' ("lead"),
      new String ' ("bass"),	 
      new String ' ("string N pad"),
      new String ' ("Guitar N Pluck"),
      new String ' ("Fx"),
      new String ' ("synth hard"),
      new String ' ("synth soft"),
      new String ' ("keyboard"),
      new String ' ("hit N drum"),
      new String ' ("drums kit"),
      new String ' ("audio in"),
      new String ' ("motion"),	 
      new String ' ("bell N Decay"),
      new String ' ("user"),
      new String ' ("arp seq"),
      new String ' ("voccoder")
     );
   
   type Categories_Record(Category_Max : Category_Index_Type) is tagged
      record
	 Category : Categories_Set_type(1..Category_Max);
	 Last       : Category_Index_type := 1;
      end record;
   
   --type Categories_Access is access all Categories_Record'Class;
   
   type Break_Type is (Null_Break, Down_Break, Up_Break, Full_Break);            
   
   type True_Table_Type is array (Category_Index_Type, Break_Type, Break_Type) of Boolean;            
   
   
   
   function Is_Formed(True_Table : True_Table_Type;			 		      
		      Category_Index : Category_Index_Type;
		      Prev       : Break_Type := Null_Break;
		      Next       : Break_Type := Null_Break) return Boolean;
   
      
   --True_Table_Default : True_Table_Type := (others => (others => (others => False)));
   
   
   type Breaks_Set_Type is array (Positive range <>) of Break_Type;
   
   --type Breaks_Set_Access is access Breaks_Set_Type;
   
   Key_Max : constant Positive := 128;
   
   type Key_Type is mod key_Max;
   
   Sens_Max : constant Positive := 128;
   
   type Sens_Type is mod Sens_Max;
   
   Length_Max : constant Positive := 128;
   
   type Length_Type is mod Length_Max;
   
   Key_Default : constant Key_Type := 0;
   Sens_Default : constant Sens_Type := 0;
   Length_Default : constant Length_Type := 1;
      
   type Note_Type is tagged
      record
	 Key    : Key_Type := Key_Default;
	 Sens   : Sens_Type := Sens_Default;
	 Length : Length_Type := Length_Default;
      end record;
   
   Null_Note : constant Note_Type := 
     (Key_Default,
      Sens_Default,
      Length_default);            
   
   type Octave_Num is new Integer range -2 .. 2;
   
   type Device_Num is new Positive range 1 .. 128;
   
   type Channel_num is new Positive range 1 .. 16;

   type Plugin_num is new Positive range 1 .. 256;
   
   type Plugin_Enum is (Null_Plugin,
			
			PC_List,
			
			CC_List,
			
			Step_Seq,
			
			Arp_Seq,
			
			NN_Mono, NN_Poly, NN_Rythm,
			
			Gen_Bass, Gen_Synth, Gen_Drums,
			
			NL_Mod);
   

end Libsens.Virtual;
