
with Text_Io;                           use Text_Io;

package body Libsens.Virtual.Step_Sequencer is
   
   
   procedure Print (Filename : in String; Plug : in Step_Seq_Plugin_record) is
      
      File : File_Type;
   begin
      
      Put_Line("Step_sequencer_Plugin Plugin : ");      
      
      Print(Filename, Plugin_Class(Plug));
      
      Open(File, Append_File, Filename);      
      Put_Line(File, Positive'Image(Plug.Bars_Max));
      for Voice_Id in Plug.Sequencer'Range loop
	 Put_Line(File, Positive'Image(Plug.Sequencer(Voice_Id).Id));
	 Put_Line(File, Key_Type'Image(Plug.Sequencer(Voice_Id).Key));	    
	 Put_Line(File, Sens_Type'Image(Plug.Sequencer(Voice_Id).Sens));
	 Put_Line(File, Length_Type'Image(Plug.Sequencer(Voice_Id).Length));
	 Put_Line(File, Positive'Image(Plug.Sequencer(Voice_Id).Bar));
	 Put_Line(File, Time_Number_Type'Image(Plug.Sequencer(Voice_Id).Number));
	 Put_Line(File, Time_Unit_Type'Image(Plug.Sequencer(Voice_Id).Step));
	 Put_Line(File, boolean'Image(Plug.Sequencer(Voice_Id).Played));	    
	 Put_Line(File, Octave_num'Image(Plug.Sequencer(Voice_Id).Octave));
	 Put_Line(File, boolean'Image(Plug.Sequencer(Voice_Id).In_Loop));	    
	 Put_Line(File, Plug.Sequencer(Voice_Id).Note.all);	 
      end loop;
      Close(File);
   end Print;   
end Libsens.Virtual.Step_Sequencer;
