with PragmARC.REM_NN_Wrapper;           use PragmARC.REM_NN_Wrapper;
with Libsens.Common;                    use Libsens.Common;
with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;
with Libsens.Virtual.Plugins;           use Libsens.Virtual.Plugins;
package Libsens.Virtual.Arp_Sequencer is
   

   type Type_Step is new T_Note with
      record         
         Set              : Boolean := True;
	 Length            : Value_Type := 6;
      end record;
   
   type Step_Access is access all Type_Step;

   type Type_Step_Table is array (Positive range <>) of Step_access;
   
   procedure Initialize
     (Step : in out Step_Access);
   
   type Arp_Seq_Plugin_Record is
     new Plugin_Class(Arp_seq) with
      record
	 Network               : access String := new String ' ("Accords.txt");
	 Reuse                 : Boolean := False;
	 Converged             : Real := 0.1;	
	 Max_Epoch             : Positive := 8000;
	 
	 Last_Step             : Positive     := 32;
	 Transpose             : value_type := 0;
	 Step_Table            : Type_Step_Table(1..32) := (others => new Type_Step);
	 Resolution            : T_Figure := simple;
	 
	 
	 Start_Chord           : Chord_Access := new T_Chord' (new T_Note' (48, 101, 64), new T_Note ' (50, 95, 64), new T_Note ' (52, 100, 64));
         Chord                 : T_Chord(1..3) := (others => new T_Note ' (64, 95, 64));
	 
      end record;
   
   procedure Print (Filename : in String; Plug : in Arp_Seq_Plugin_record);
   
end Libsens.Virtual.Arp_Sequencer;
