with Text_Io;                           use Text_Io;
package body Libsens.Virtual.Arp_Sequencer is
   procedure Print (Filename : in String; Plug : in Arp_Seq_Plugin_Record) is
      File : File_Type;
   begin
      Put_Line("Arp_Sequencer Plugin : ");
      Print(Filename, Plugin_Class(Plug));
      
      Open(File, Append_File, Filename);      
      
      Put_Line(File, Plug.Network.all);      
      Put_Line(File, boolean'Image(Plug.Reuse));	    
      Put_Line(File, real'Image(Plug.converged));
      Put_Line(File, Positive'Image(Plug.Max_epoch));
      Put_Line(File, Positive'Image(Plug.Last_Step));
      Put_Line(File, Value_Type'Image(Plug.transpose));
      Put_Line(File, T_Figure'Image(Plug.resolution));
      
      for I in Plug.Step_Table'Range loop
	 Put_Line(File, boolean'Image(Plug.Step_Table(I).Set));
      end loop;
      
      for I in Plug.Start_Chord'Range loop
	 
	 Put_Line(File, Value_Type'Image(Plug.Start_Chord(I).key));
	 Put_Line(File, Value_Type'Image(Plug.Start_Chord(I).vel));
	 Put_Line(File, Value_Type'Image(Plug.Start_Chord(I).len));
	 
      end loop;
      Close(File);
      
   end Print;   
   
      
   procedure Initialize
      (Step : in out Step_Access) is
   begin
      Step := new Type_Step;             
   end Initialize;

      

end Libsens.Virtual.Arp_Sequencer;
