



with Libsens.Mal;                       use Libsens.Mal;
with Libsens.Common;                    use Libsens.Common;

with Libsens.Arch;                      use Libsens.Arch;
with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;

generic

package Libsens.Rhetorica is
   

   
   
   subtype Valid_Category_Type is Category_Type range lead..split;
   
   
   
   type Composer_Type;
      
   
   task type Compositor_Type (Composer : access Composer_Type) is
      pragma Storage_Size (16777216);
      entry Initialize(Filename : in String);
      entry Halt;      
      
      entry Respond(Filename : in String; Channel : in Channel_Type; sequence : out Seq_Vectors.vector);
   end Compositor_Type;
   
   type Composer_Type (Form : Form_Type;
		       cat : Valid_Category_Type) is limited
			  
      record	 
	 Arche                  : access Arche_Type'Class;	 
	 Compositor             : Compositor_Type(Composer_Type'Access);	 
      end record;
   
   type Composer_Access is access all Composer_Type;          

end Libsens.Rhetorica;
