


with Text_Io;                           use Text_Io;

package body Libsens.Rhetorica is



   function Initialize (Filename : in String;
			Form : Form_Type;
			Category : Category_Type) return arche_access is

      Arche : arche_access;
   begin
      case Form is
	 when ACID =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  ACID_BASS_Type;
	       when LEAD =>
		  Arche := new  ACID_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  ACID_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  ACID_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  ACID_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  ACID_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  ACID_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  ACID_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  ACID_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  ACID_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  ACID_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  ACID_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  ACID_SPLIT_Type;
		  when AUDIO_IN =>
		     Arche := new  ACID_AUDIO_IN_Type;
		  when VOCODER =>
		     Arche := new  ACID_VOCODER_Type;
		  when USER =>
		     Arche := new  ACID_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  ACID_DRUMS_KIT_Type;

	    end case;
	 when TECHNO =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  TECHNO_BASS_Type;
	       when LEAD =>
		  Arche := new  TECHNO_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  TECHNO_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  TECHNO_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  TECHNO_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  TECHNO_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  TECHNO_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  TECHNO_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  TECHNO_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  TECHNO_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  TECHNO_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  TECHNO_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  TECHNO_SPLIT_Type;
		  when AUDIO_IN =>
		     Arche := new  TECHNO_AUDIO_IN_Type;
		  when VOCODER =>
		     Arche := new  TECHNO_VOCODER_Type;
		  when USER =>
		     Arche := new  TECHNO_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  TECHNO_DRUMS_KIT_Type;

	    end case;
	 when TRIBE =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  TRIBE_BASS_Type;
	       when LEAD =>
		  Arche := new  TRIBE_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  TRIBE_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  TRIBE_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  TRIBE_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  TRIBE_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  TRIBE_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  TRIBE_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  TRIBE_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  TRIBE_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  TRIBE_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  TRIBE_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  TRIBE_SPLIT_Type;
		  when AUDIO_IN =>
		     Arche := new  TRIBE_AUDIO_IN_Type;
		  when VOCODER =>
		     Arche := new  TRIBE_VOCODER_Type;
		  when USER =>
		     Arche := new  TRIBE_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  TRIBE_DRUMS_KIT_Type;


	    end case;
	 when HARDTECH =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  HARDTECH_BASS_Type;
	       when LEAD =>
		  Arche := new  HARDTECH_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  HARDTECH_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  HARDTECH_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  HARDTECH_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  HARDTECH_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  HARDTECH_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  HARDTECH_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  HARDTECH_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  HARDTECH_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  HARDTECH_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  HARDTECH_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  HARDTECH_SPLIT_Type;
		  when AUDIO_IN =>
		     Arche := new  HARDTECH_AUDIO_IN_Type;
		  when VOCODER =>
		     Arche := new  HARDTECH_VOCODER_Type;
		  when USER =>
		     Arche := new  HARDTECH_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  HARDTECH_DRUMS_KIT_Type;

	    end case;
	 when HARDCORE =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  HARDCORE_BASS_Type;
	       when LEAD =>
		  Arche := new  HARDCORE_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  HARDCORE_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  HARDCORE_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  HARDCORE_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  HARDCORE_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  HARDCORE_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  HARDCORE_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  HARDCORE_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  HARDCORE_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  HARDCORE_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  HARDCORE_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  HARDCORE_SPLIT_Type;
		  when AUDIO_IN =>
		     Arche := new  HARDCORE_AUDIO_IN_Type;
		  when VOCODER =>
		     Arche := new  HARDCORE_VOCODER_Type;
		  when USER =>
		     Arche := new  HARDCORE_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  HARDCORE_DRUMS_KIT_Type;

	    end case;
	 when TRANCE =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  TRANCE_BASS_Type;
	       when LEAD =>
		  Arche := new  TRANCE_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  TRANCE_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  TRANCE_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  TRANCE_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  TRANCE_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  TRANCE_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  TRANCE_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  TRANCE_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  TRANCE_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  TRANCE_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  TRANCE_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  TRANCE_SPLIT_Type;
		  when AUDIO_IN =>
		     Arche := new  TRANCE_AUDIO_IN_Type;
		  when VOCODER =>
		     Arche := new  TRANCE_VOCODER_Type;
		  when USER =>
		     Arche := new  TRANCE_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  TRANCE_DRUMS_KIT_Type;

	    end case;
	 when MINIMAL =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  MINIMAL_BASS_Type;
	       when LEAD =>
		  Arche := new  MINIMAL_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  MINIMAL_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  MINIMAL_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  MINIMAL_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  MINIMAL_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  MINIMAL_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  MINIMAL_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  MINIMAL_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  MINIMAL_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  MINIMAL_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  MINIMAL_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  MINIMAL_SPLIT_Type;
	       when AUDIO_IN =>
		  Arche := new  MINIMAL_AUDIO_IN_Type;
	       when VOCODER =>
		  Arche := new  MINIMAL_VOCODER_Type;
	       when USER =>
		  Arche := new  MINIMAL_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  MINIMAL_DRUMS_KIT_Type;
		  
	    end case;
	 when DNB =>
	    case Category is
	       when Null_Cat =>
		  null;
	       when BASS =>
		  Arche := new  DNB_BASS_Type;
	       when LEAD =>
		  Arche := new  DNB_LEAD_Type;
	       when SYNTH_HARD =>
		  Arche := new  DNB_SYNTH_HARD_Type;
	       when SYNTH_SOFT =>
		  Arche := new  DNB_SYNTH_SOFT_Type;
	       when MOTION =>
		  Arche := new  DNB_MOTION_Type;
	       when STRINGS_N_PADS =>
		  Arche := new  DNB_STRINGS_N_PADS_Type;
	       when KEYBOARD =>
		  Arche := new  DNB_KEYBOARD_Type;
	       when GUITARE_N_PLUCK =>
		  Arche := new  DNB_GUITARE_N_PLUCK_Type;
	       when BELL_N_DECAY =>
		  Arche := new  DNB_BELL_N_DECAY_Type;
	       when HIT_N_DRUM =>
		  Arche := new  DNB_HIT_N_DRUM_Type;
	       when S_E =>
		  Arche := new  DNB_S_E_Type;
	       when ARP_SEQ =>
		  Arche := new  DNB_ARP_SEQ_Type;
	       when SPLIT =>
		  Arche := new  DNB_SPLIT_Type;
		  when AUDIO_IN =>
		     Arche := new  DNB_AUDIO_IN_Type;
		  when VOCODER =>
		     Arche := new  DNB_VOCODER_Type;
		  when USER =>
		     Arche := new  DNB_USER_Type;
	       when DRUMS_KIT =>
		  Arche := new  DNB_DRUMS_KIT_Type;

	    end case;
      end case;
      
      Arche.Filename := new String ' (Filename);
      
      return Arche;
   end Initialize;

   
   
   task body Compositor_Type is



      End_Of_Task : Boolean := False;
      
      --Filename : access String := new String ' ("");
      

   begin
      
      while not End_Of_Task loop
	 loop
	    select


	       accept Initialize(Filename : in String) do
		  New_Line(2);
		  --Put_Line("Initialize Arch filename : " & Filename);
		  Composer.Arche := Initialize(Filename, Composer.Form, Composer.Cat);
		  --Put_Line("Initialize Arch filename : " & Filename & " done.");

	       end Initialize;
	       exit;
	    or

	       accept Halt do

		  End_Of_Task := True;
	       end Halt;
	       exit;
	    end select;
	 end loop;
	 while not End_Of_Task loop
	    select
	       accept Halt do

		  End_Of_Task := True;
	       end Halt;
	       exit;
	    or
	       accept Respond(Filename : in String; Channel : in Channel_Type; sequence : out Seq_Vectors.vector) do

		  
		  --Text_Io.Put_line("Composer: " & Form_Type'Image(Composer.Arche.Form) & "-" & Valid_Category_Type'Image(Composer.Arche.Category) & "- " & Channel_Type'Image(Channel) & " respond...");
		  

		  
		  
		  --Text_Io.Put_Line("Natural language compose ....");
		  case Composer.Arche.Form is
		     when ACID =>
			--Text_Io.Put_Line("Natural language compose Acid...");
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := ACID_BASS_Type(Composer.Arche.all).Compose(Channel);
			      --Text_Io.Put_Line("Natural language compose Acid bass...");
			   when LEAD =>
			      Sequence := ACID_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := ACID_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := ACID_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := ACID_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := ACID_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := ACID_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := ACID_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := ACID_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := ACID_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := ACID_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := ACID_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := ACID_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := ACID_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := ACID_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := ACID_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := ACID_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		     when TECHNO =>
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := TECHNO_BASS_Type(Composer.Arche.all).Compose(Channel);
			   when LEAD =>
			      Sequence := TECHNO_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := TECHNO_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := TECHNO_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := TECHNO_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := TECHNO_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := TECHNO_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := TECHNO_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := TECHNO_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := TECHNO_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := TECHNO_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := TECHNO_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := TECHNO_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := TECHNO_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := TECHNO_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := TECHNO_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := TECHNO_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		     when TRIBE =>
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := TRIBE_BASS_Type(Composer.Arche.all).Compose(Channel);
			   when LEAD =>
			      Sequence := TRIBE_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := TRIBE_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := TRIBE_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := TRIBE_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := TRIBE_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := TRIBE_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := TRIBE_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := TRIBE_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := TRIBE_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := TRIBE_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := TRIBE_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := TRIBE_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := TRIBE_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := TRIBE_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := TRIBE_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := TRIBE_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		     when HARDTECH =>
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := HARDTECH_BASS_Type(Composer.Arche.all).Compose(Channel);
			   when LEAD =>
			      Sequence := HARDTECH_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := HARDTECH_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := HARDTECH_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := HARDTECH_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := HARDTECH_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := HARDTECH_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := HARDTECH_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := HARDTECH_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := HARDTECH_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := HARDTECH_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := HARDTECH_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := HARDTECH_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := HARDTECH_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := HARDTECH_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := HARDTECH_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := HARDTECH_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		     when HARDCORE =>
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := HARDCORE_BASS_Type(Composer.Arche.all).Compose(Channel);
			   when LEAD =>
			      Sequence := HARDCORE_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := HARDCORE_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := HARDCORE_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := HARDCORE_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := HARDCORE_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := HARDCORE_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := HARDCORE_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := HARDCORE_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := HARDCORE_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := HARDCORE_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := HARDCORE_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := HARDCORE_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := HARDCORE_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := HARDCORE_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := HARDCORE_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := HARDCORE_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		     when TRANCE =>
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := TRANCE_BASS_Type(Composer.Arche.all).Compose(Channel);
			   when LEAD =>
			      Sequence := TRANCE_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := TRANCE_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := TRANCE_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := TRANCE_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := TRANCE_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := TRANCE_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := TRANCE_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := TRANCE_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := TRANCE_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := TRANCE_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := TRANCE_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := TRANCE_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := TRANCE_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := TRANCE_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := TRANCE_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := TRANCE_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		     when MINIMAL =>
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := MINIMAL_BASS_Type(Composer.Arche.all).Compose(Channel);
			   when LEAD =>
			      Sequence := MINIMAL_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := MINIMAL_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := MINIMAL_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := MINIMAL_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := MINIMAL_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := MINIMAL_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := MINIMAL_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := MINIMAL_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := MINIMAL_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := MINIMAL_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := MINIMAL_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := MINIMAL_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := MINIMAL_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := MINIMAL_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := MINIMAL_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := MINIMAL_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		     when DNB =>
			case Composer.Arche.Category is
			   when Null_Cat =>
			      null;
			   when BASS =>
			      Sequence := DNB_BASS_Type(Composer.Arche.all).Compose(Channel);
			   when LEAD =>
			      Sequence := DNB_LEAD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_HARD =>
			      Sequence := DNB_SYNTH_HARD_Type(Composer.Arche.all).Compose(Channel);
			   when SYNTH_SOFT =>
			      Sequence := DNB_SYNTH_SOFT_Type(Composer.Arche.all).Compose(Channel);
			   when MOTION =>
			      Sequence := DNB_MOTION_Type(Composer.Arche.all).Compose(Channel);
			   when STRINGS_N_PADS =>
			      Sequence := DNB_STRINGS_N_PADS_Type(Composer.Arche.all).Compose(Channel);
			   when KEYBOARD =>
			      Sequence := DNB_KEYBOARD_Type(Composer.Arche.all).Compose(Channel);
			   when GUITARE_N_PLUCK =>
			      Sequence := DNB_GUITARE_N_PLUCK_Type(Composer.Arche.all).Compose(Channel);
			   when BELL_N_DECAY =>
			      Sequence := DNB_BELL_N_DECAY_Type(Composer.Arche.all).Compose(Channel);
			   when HIT_N_DRUM =>
			      Sequence := DNB_HIT_N_DRUM_Type(Composer.Arche.all).Compose(Channel);
			   when S_E =>
			      Sequence := DNB_S_E_Type(Composer.Arche.all).Compose(Channel);
			   when ARP_SEQ =>
			      Sequence := DNB_ARP_SEQ_Type(Composer.Arche.all).Compose(Channel);
			   when SPLIT =>
			      Sequence := DNB_SPLIT_Type(Composer.Arche.all).Compose(Channel);
			   when AUDIO_IN =>
			      Sequence := DNB_AUDIO_IN_Type(Composer.Arche.all).Compose(Channel);
			   when VOCODER =>
			      Sequence := DNB_VOCODER_Type(Composer.Arche.all).Compose(Channel);
			   when USER =>
			      Sequence := DNB_USER_Type(Composer.Arche.all).Compose(Channel);
			   when DRUMS_KIT =>
			      Sequence := DNB_DRUMS_KIT_Type(Composer.Arche.all).Compose(Channel);
			end case;

		  end case;


		  --Text_Io.Put_line("Composer: " & Form_Type'Image(Composer.Arche.Form) & "-" & Valid_Category_Type'Image(Composer.Arche.Category) & "- " & Channel_Type'Image(Channel) & " responded.");
	       end Respond;

	    end select;
	 end loop;
      end loop;
      Text_Io.Put_Line("Composer: " & Form_Type'Image(Composer.Arche.Form) & "-" & Valid_Category_Type'Image(Composer.Arche.Category) & " halted.");
   end Compositor_Type;


end Libsens.Rhetorica;
