
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

with Ada.Calendar;                      use Ada.Calendar;
package Libsens.Processing.Step_Sequencer is
   
   type Step_Sequencer_Processing(Plugin : Abstract_Plugin_Access);
   
   task type Step_Sequencer_Process (Step_Sequencer : access Step_Sequencer_Processing) is
      entry Initialize(Options : in Work_Options_Access);
      entry Start(Start_time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
      entry Stop;
      entry Halt;
   end Step_Sequencer_Process;
   
   type Step_Sequencer_Processing(Plugin : Abstract_Plugin_Access) is new Plugin_Processing(Step_Seq) with
      record
	 Process : Step_Sequencer_Process(Step_Sequencer_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Step_Sequencer_Processing; Options : in Work_Options_Access);
   
   procedure Start(Plugin_Process : in Step_Sequencer_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
   procedure Stop(Plugin_Process : in Step_Sequencer_Processing);
   procedure Halt(Plugin_Process : in Step_Sequencer_Processing);
end Libsens.Processing.Step_Sequencer;
