
with Libsens.Common;                    use Libsens.Common;
with Libsens.MIDI.Instruments;          use Libsens.MIDI.Instruments;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Common;         use Libsens.Processing.Common;

with Ada.Calendar;                      use Ada.Calendar;
with Interfaces.C;                      use Interfaces.C;
package Libsens.Processing.Plugins is
   
   type Plugin_Processing(Class : Plugin_Enum);
   
   task type Event_Process_Type(Driver : access Plugin_Processing) is
      
      entry Receive (Device  : in Device_Num;
		     Date    : in Time;
		     Message : in Interfaces.C.Long;
		     Hour    : in Duration;
		     Tempo   : in Tempo_Type);
      entry Halt;
   end Event_Process_Type;
   
   
   type Plugin_Processing(Class : Plugin_Enum) is abstract tagged limited
      record
	 Box           : access Messages_Box;
	 Instruments   : access Bandmaster_Record;
	 Event_Process : Event_Process_Type(Plugin_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Plugin_Processing; Options : in Work_Options_access) is abstract;
   procedure Start(Plugin_Process : in Plugin_Processing; Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type) is abstract;
   procedure Stop(Plugin_Process : in Plugin_Processing) is abstract;
   procedure Halt(Plugin_Process : in Plugin_Processing) is abstract;
end Libsens.Processing.Plugins;
