
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

with Ada.Calendar;                      use Ada.Calendar;
package Libsens.Processing.Genetical_Synth is
   
   type Genetical_Synth_Processing(Plugin : Abstract_Plugin_Access);
   
   task type Genetical_Synth_Process (Genetical_Synth : access Genetical_Synth_Processing) is
      entry Initialize(Options : in Work_Options_Access);
      entry Start(Start_time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
      entry Stop;
      entry Halt;
   end Genetical_Synth_Process;
   
   type Genetical_Synth_Processing(Plugin : Abstract_Plugin_Access) is new Plugin_Processing(Gen_Synth) with
      record
	 Process : Genetical_Synth_Process(Genetical_Synth_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Genetical_Synth_Processing;Options : in Work_Options_Access);
   
   procedure Start(Plugin_Process : in Genetical_Synth_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
   procedure Stop(Plugin_Process : in Genetical_Synth_Processing);
   procedure Halt(Plugin_Process : in Genetical_Synth_Processing);
end Libsens.Processing.Genetical_Synth;
