
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

with Ada.Calendar;                      use Ada.Calendar;
package Libsens.Processing.Genetical_Bass is
   
   type Genetical_Bass_Processing(Plugin : Abstract_Plugin_Access);
   
   task type Genetical_Bass_Process (Genetical_Bass : access Genetical_Bass_Processing) is
      entry Initialize(Options : in Work_Options_Access);
      entry Start(Start_time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
      entry Stop;
      entry Halt;
   end Genetical_Bass_Process;
   
   type Genetical_Bass_Processing(Plugin : Abstract_Plugin_Access) is new Plugin_Processing(Gen_Bass) with
      record
	 Process : Genetical_Bass_Process(Genetical_Bass_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Genetical_Bass_Processing;Options : in Work_Options_Access);
   
   procedure Start(Plugin_Process : in Genetical_Bass_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
   procedure Stop(Plugin_Process : in Genetical_Bass_Processing);
   procedure Halt(Plugin_Process : in Genetical_Bass_Processing);
end Libsens.Processing.Genetical_Bass;
